/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia;

import com.sun.jna.Platform;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.List;
import java.util.ServiceLoader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.watermedia.api.WaterMediaAPI;
import org.watermedia.core.exceptions.UnsupportedArchitechtureException;
import org.watermedia.core.tools.ArgTool;
import org.watermedia.core.tools.DataTool;
import org.watermedia.core.tools.JarTool;
import org.watermedia.loaders.ILoader;

public class WaterMedia {
    public static final String ID = "watermedia";
    public static final String NAME = "WATERMeDIA";
    public static final Logger LOGGER = LogManager.getLogger((String)"watermedia");
    public static final Marker IT = MarkerManager.getMarker((String)"Bootstrap");
    public static final String VERSION = JarTool.readString("/watermedia/version.cfg");
    public static final String USER_AGENT = "WaterMedia/" + VERSION;
    public static final ArgTool NO_BOOTING = new ArgTool("watermedia.disableBoot");
    public static final ArgTool NO_VLC = new ArgTool("watermedia.disableVLC");
    public static final ArgTool YES_SLAVISM = new ArgTool("watermedia.slavist");
    private static ILoader bootstrap;
    private static WaterMedia instance;

    private WaterMedia() {
    }

    public static WaterMedia prepare(ILoader boot) {
        if (boot == null) {
            throw new NullPointerException("Bootstrap is null");
        }
        if (instance != null) {
            throw new NullPointerException("WaterMedia is already prepared");
        }
        LOGGER.info(IT, "Preparing '{}' on '{}'", (Object)NAME, (Object)boot.name());
        LOGGER.info(IT, "WaterMedia version '{}'", (Object)VERSION);
        LOGGER.info(IT, "OS Detected: {} ({})", (Object)System.getProperty("os.name"), (Object)Platform.ARCH);
        LOGGER.info(IT, "Runtime memory Usage: {}MB/{}MB", (Object)((Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 0x100000L), (Object)(Runtime.getRuntime().maxMemory() / 0x100000L));
        bootstrap = boot;
        instance = new WaterMedia();
        return instance;
    }

    public void start() throws Exception {
        if (NO_BOOTING.getAsBoolean()) {
            LOGGER.error(IT, "Refusing to bootstrap WATERMeDIA, detected {}", (Object)NO_BOOTING);
            return;
        }
        List<WaterMediaAPI> modules = DataTool.toList(ServiceLoader.load(WaterMediaAPI.class));
        modules.sort(Comparator.comparingInt(e -> e.priority().ordinal()));
        if (!Platform.is64Bit()) {
            throw new UnsupportedArchitechtureException();
        }
        for (WaterMediaAPI m : modules) {
            LOGGER.info(IT, "Starting {}", (Object)m.getClass().getSimpleName());
            if (!m.prepare(bootstrap)) {
                LOGGER.warn(IT, "Module {} refuses to be loaded, skipping", (Object)m.getClass().getSimpleName());
                continue;
            }
            m.start(bootstrap);
            LOGGER.info(IT, "Module {} loaded successfully", (Object)m.getClass().getSimpleName());
        }
        LOGGER.info(IT, "Startup finished");
        LOGGER.info(IT, "Are you ready for trouble?");
    }

    public static ILoader getLoader() {
        return bootstrap;
    }

    public static Path getConfigDir() {
        return bootstrap.processDir().resolve("config/watermedia");
    }

    public static void setSlavismMode(boolean mode) {
        YES_SLAVISM.override(String.valueOf(mode));
    }

    public static String asResource(String path) {
        return "watermedia:" + path;
    }
}

