/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.effects.particles.plumes;

import com.simibubi.create.foundation.ponder.PonderWorld;
import com.simibubi.create.foundation.utility.worldWrappers.WrappedClientWorld;
import net.minecraft.client.ParticleStatus;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.NoRenderParticle;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import rbasamoyai.createbigcannons.CBCClientCommon;
import rbasamoyai.createbigcannons.config.CBCConfigs;
import rbasamoyai.createbigcannons.effects.particles.plumes.BigCannonPlumeParticleData;
import rbasamoyai.createbigcannons.effects.particles.smoke.CannonSmokeParticleData;

public class BigCannonPlumeParticle
extends NoRenderParticle {
    private final Vec3 direction;
    private final float size;
    private final float power;
    private final boolean isPonderWorld;

    BigCannonPlumeParticle(ClientLevel level, double x, double y, double z, double dx, double dy, double dz, float size, float power) {
        super(level, x, y, z);
        WrappedClientWorld wrapped;
        this.direction = new Vec3(dx, dy, dz);
        this.size = size;
        this.power = power;
        this.f_107226_ = 0.0f;
        this.f_172258_ = 0.9f;
        float f = this.power / 4.0f;
        this.m_172260_(dx * (double)f, dy * (double)f, dz * (double)f);
        this.isPonderWorld = level instanceof WrappedClientWorld && (wrapped = (WrappedClientWorld)level).getWrappedWorld() instanceof PonderWorld;
    }

    public void m_5989_() {
        int i;
        if (!((Boolean)CBCConfigs.CLIENT.showBigCannonPlumes.get()).booleanValue()) {
            this.m_107274_();
            return;
        }
        ParticleStatus status = CBCClientCommon.getParticleStatus();
        Vec3 right = this.direction.m_82537_(new Vec3(Direction.UP.m_253071_()));
        Vec3 up = this.direction.m_82537_(right);
        double progress = this.f_107225_ == 0 ? 1.0 : (double)Mth.m_14036_((float)((float)this.f_107224_ / (float)this.f_107225_), (float)0.0f, (float)1.0f);
        float smallScale = this.size * 0.25f;
        int countScale = switch (status) {
            default -> throw new IncompatibleClassChangeError();
            case ParticleStatus.ALL -> 5;
            case ParticleStatus.DECREASED -> 3;
            case ParticleStatus.MINIMAL -> 1;
        };
        int count = Math.min(3, Mth.m_14167_((float)(smallScale * (float)countScale)));
        for (int i2 = 0; i2 < count; ++i2) {
            double dirScale = 0.3 * progress + 0.8 + this.f_107223_.m_188500_() * 0.25;
            double dirPerpScale = smallScale * 0.25f;
            Vec3 vel = this.direction.m_82490_(dirScale).m_82549_(right.m_82490_((this.f_107223_.m_188500_() - this.f_107223_.m_188500_()) * dirPerpScale)).m_82549_(up.m_82490_((this.f_107223_.m_188500_() - this.f_107223_.m_188500_()) * dirPerpScale));
            int lifetime = 30 + this.f_107223_.m_188503_(10) + Mth.m_14165_((double)(10.0 * progress)) + (int)Math.ceil(this.power * this.power) / 2;
            if (this.isPonderWorld) {
                this.f_107208_.m_7106_((ParticleOptions)new CannonSmokeParticleData(this.power, smallScale, lifetime, 0.95f), this.f_107212_, this.f_107213_, this.f_107214_, vel.f_82479_, vel.f_82480_, vel.f_82481_);
                continue;
            }
            this.f_107208_.m_6493_((ParticleOptions)new CannonSmokeParticleData(this.power, smallScale, lifetime, 0.95f), true, this.f_107212_, this.f_107213_, this.f_107214_, vel.f_82479_, vel.f_82480_, vel.f_82481_);
        }
        if (this.f_107224_ == 0 && status == ParticleStatus.ALL && ((Boolean)CBCConfigs.CLIENT.showExtraBigCannonSmoke.get()).booleanValue()) {
            float scale2 = smallScale * 0.25f;
            int count2 = (int)Math.floor(smallScale * 10.0f);
            for (i = 0; i < count2; ++i) {
                Vec3 vel = this.direction.m_82490_(0.5).m_82549_(right.m_82490_((this.f_107223_.m_188500_() - this.f_107223_.m_188500_()) * (double)scale2)).m_82549_(up.m_82490_((this.f_107223_.m_188500_() - this.f_107223_.m_188500_()) * (double)scale2));
                if (this.isPonderWorld) {
                    this.f_107208_.m_7106_((ParticleOptions)ParticleTypes.f_123796_, this.f_107212_, this.f_107213_, this.f_107214_, vel.f_82479_, vel.f_82480_, vel.f_82481_);
                    continue;
                }
                this.f_107208_.m_6493_((ParticleOptions)ParticleTypes.f_123796_, true, this.f_107212_, this.f_107213_, this.f_107214_, vel.f_82479_, vel.f_82480_, vel.f_82481_);
            }
        }
        if (this.f_107224_ < 5 && status == ParticleStatus.ALL && ((Boolean)CBCConfigs.CLIENT.showExtraBigCannonFlames.get()).booleanValue()) {
            float scale2 = 0.05f;
            float count2 = smallScale * 5.0f;
            i = 0;
            while ((float)i < count2) {
                Vec3 vel1 = this.direction.m_82490_(0.05 + 0.2 * this.f_107223_.m_188500_()).m_82549_(right.m_82490_((this.f_107223_.m_188500_() - this.f_107223_.m_188500_()) * (double)scale2)).m_82549_(up.m_82490_((this.f_107223_.m_188500_() - this.f_107223_.m_188500_()) * (double)scale2));
                if (this.isPonderWorld) {
                    this.f_107208_.m_7106_((ParticleOptions)ParticleTypes.f_123744_, this.f_107212_, this.f_107213_, this.f_107214_, vel1.f_82479_, vel1.f_82480_, vel1.f_82481_);
                } else {
                    this.f_107208_.m_6493_((ParticleOptions)ParticleTypes.f_123744_, false, this.f_107212_, this.f_107213_, this.f_107214_, vel1.f_82479_, vel1.f_82480_, vel1.f_82481_);
                }
                ++i;
            }
        }
        super.m_5989_();
    }

    public static class Provider
    implements ParticleProvider<BigCannonPlumeParticleData> {
        public Particle createParticle(BigCannonPlumeParticleData data, ClientLevel level, double x, double y, double z, double dx, double dy, double dz) {
            return new BigCannonPlumeParticle(level, x, y, z, dx, dy, dz, data.size(), data.power());
        }
    }
}

