/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.effects.particles.splashes;

import net.minecraft.client.ParticleStatus;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.NoRenderParticle;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import rbasamoyai.createbigcannons.CBCClientCommon;
import rbasamoyai.createbigcannons.effects.particles.splashes.ProjectileSplashParticleData;
import rbasamoyai.createbigcannons.effects.particles.splashes.SplashSprayParticleData;

public class ProjectileSplashParticle
extends NoRenderParticle {
    private final float scale;
    private final float light;

    ProjectileSplashParticle(ClientLevel level, double x, double y, double z, double dx, double dy, double dz, float r, float g, float b, float light) {
        super(level, x, y, z);
        this.f_107215_ = dx;
        this.f_107216_ = dy;
        this.f_107217_ = dz;
        this.f_107227_ = r;
        this.f_107228_ = g;
        this.f_107229_ = b;
        this.scale = (float)Math.sqrt(dx * dx + dy * dy + dz * dz) * 2.0f;
        this.light = light;
    }

    public void m_5989_() {
        int particleCount = switch (CBCClientCommon.getParticleStatus()) {
            default -> throw new IncompatibleClassChangeError();
            case ParticleStatus.ALL -> 10;
            case ParticleStatus.DECREASED -> 5;
            case ParticleStatus.MINIMAL -> 2;
        };
        double velScale = 1.0 - (double)this.f_107224_ / (double)this.f_107225_;
        Vec3 vel = new Vec3(this.f_107215_, this.f_107216_, this.f_107217_).m_82490_(velScale);
        double length = vel.m_82553_();
        int lifetime = Math.max(Mth.m_14165_((double)(80.0 * length)), 40);
        SplashSprayParticleData options = new SplashSprayParticleData(this.f_107227_, this.f_107228_, this.f_107229_, this.scale, this.light, lifetime);
        if (this.f_107224_ < 2 && (double)this.scale >= 0.5) {
            Vec3 focalPoint = new Vec3(this.f_107212_, this.f_107213_, this.f_107214_).m_82549_(vel.m_82490_(6.0));
            double areaScale = 8.0 * length;
            for (int i = 0; i < particleCount; ++i) {
                double rx = this.f_107212_ + (this.f_107223_.m_188500_() - this.f_107223_.m_188500_()) * areaScale;
                double ry = this.f_107213_ - 0.5;
                double rz = this.f_107214_ + (this.f_107223_.m_188500_() - this.f_107223_.m_188500_()) * areaScale;
                double dx1 = (focalPoint.f_82479_ - rx) * 0.01 + (this.f_107223_.m_188500_() - this.f_107223_.m_188500_()) * 0.025;
                double dy1 = (focalPoint.f_82480_ - ry) * 0.03 + (this.f_107223_.m_188500_() - this.f_107223_.m_188500_()) * 0.3;
                double dz1 = (focalPoint.f_82481_ - rz) * 0.01 + (this.f_107223_.m_188500_() - this.f_107223_.m_188500_()) * 0.025;
                this.f_107208_.m_6493_((ParticleOptions)options, true, rx, ry, rz, dx1, dy1, dz1);
            }
        } else {
            float f = Math.min(this.scale, 1.5f);
            for (int i = 0; i < particleCount; ++i) {
                double rx = this.f_107212_ + (this.f_107223_.m_188500_() - this.f_107223_.m_188500_()) * (double)f;
                double ry = this.f_107213_ + 0.5;
                double rz = this.f_107214_ + (this.f_107223_.m_188500_() - this.f_107223_.m_188500_()) * (double)f;
                double dx1 = vel.f_82479_ + (this.f_107223_.m_188500_() - this.f_107223_.m_188500_()) * 0.25 * (double)f;
                double dy1 = vel.f_82480_ + (this.f_107223_.m_188500_() - this.f_107223_.m_188500_()) * 0.35;
                double dz1 = vel.f_82481_ + (this.f_107223_.m_188500_() - this.f_107223_.m_188500_()) * 0.25 * (double)f;
                this.f_107208_.m_6493_((ParticleOptions)options, true, rx, ry, rz, dx1, dy1, dz1);
            }
        }
        if (++this.f_107224_ >= this.f_107225_) {
            this.m_107274_();
        }
    }

    public static class Provider
    implements ParticleProvider<ProjectileSplashParticleData> {
        public Particle createParticle(ProjectileSplashParticleData data, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            ProjectileSplashParticle particle = new ProjectileSplashParticle(level, x, y, z, xSpeed, ySpeed, zSpeed, data.r(), data.g(), data.b(), data.light());
            particle.m_107257_(11);
            return particle;
        }
    }
}

