/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.remix;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.contraptions.AssemblyException;
import com.simibubi.create.content.contraptions.BlockMovementChecks;
import com.simibubi.create.content.contraptions.Contraption;
import com.simibubi.create.content.contraptions.chassis.ChassisBlockEntity;
import com.simibubi.create.content.contraptions.gantry.GantryContraption;
import com.simibubi.create.content.contraptions.glue.SuperGlueEntity;
import com.simibubi.create.content.contraptions.piston.MechanicalPistonBlock;
import com.simibubi.create.content.contraptions.piston.MechanicalPistonHeadBlock;
import com.simibubi.create.content.contraptions.pulley.PulleyContraption;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.infrastructure.config.AllConfigs;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.PistonType;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.material.PushReaction;
import org.apache.commons.lang3.tuple.Pair;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import rbasamoyai.createbigcannons.cannon_loading.CBCModifiedContraptionRegistry;
import rbasamoyai.createbigcannons.cannon_loading.CanLoadBigCannon;
import rbasamoyai.createbigcannons.cannons.CannonContraptionProviderBlock;
import rbasamoyai.createbigcannons.cannons.big_cannons.BigCannonBehavior;
import rbasamoyai.createbigcannons.cannons.big_cannons.BigCannonBlock;
import rbasamoyai.createbigcannons.cannons.big_cannons.IBigCannonBlockEntity;
import rbasamoyai.createbigcannons.index.CBCBlocks;
import rbasamoyai.createbigcannons.munitions.big_cannon.BigCannonMunitionBlock;
import rbasamoyai.createbigcannons.remix.HasFragileContraption;
import rbasamoyai.createbigcannons.remix.forge.ContraptionRemixImpl;

public class ContraptionRemix {
    public static boolean customBlockPlacement(Contraption contraption, LevelAccessor levelAccessor, BlockPos pos, BlockState state) {
        if (CBCModifiedContraptionRegistry.canLoadBigCannon(contraption) && contraption.entity != null) {
            boolean isBrokenDisassembly;
            BlockPos entityAnchor = BlockPos.m_274446_((Position)contraption.entity.getAnchorVec().m_82520_(0.5, 0.5, 0.5));
            BlockPos blockPos = pos.m_121996_((Vec3i)entityAnchor);
            StructureTemplate.StructureBlockInfo blockInfo = (StructureTemplate.StructureBlockInfo)contraption.getBlocks().get(blockPos);
            BlockEntity blockEntity1 = levelAccessor.m_7702_(pos);
            BlockState intersectState = levelAccessor.m_8055_(pos);
            if (CBCModifiedContraptionRegistry.isFragileContraption(contraption) && (isBrokenDisassembly = ((HasFragileContraption)contraption).createbigcannons$isBrokenDisassembly()) && !intersectState.m_60795_() && blockInfo != null && !blockInfo.f_74676_().m_60795_()) {
                BlockEntity contraptionBE = blockInfo.f_74677_() == null ? null : BlockEntity.m_155241_((BlockPos)BlockPos.f_121853_, (BlockState)blockInfo.f_74676_(), (CompoundTag)blockInfo.f_74677_());
                Block.m_49881_((BlockState)blockInfo.f_74676_(), (Level)contraption.entity.m_9236_(), (BlockPos)pos, (BlockEntity)contraptionBE, null, (ItemStack)ItemStack.f_41583_);
                levelAccessor.m_46796_(2001, pos, Block.m_49956_((BlockState)blockInfo.f_74676_()));
                levelAccessor.m_142346_((Entity)contraption.entity, GameEvent.f_157794_, pos);
                return true;
            }
            if (blockEntity1 instanceof IBigCannonBlockEntity) {
                IBigCannonBlockEntity cannon = (IBigCannonBlockEntity)blockEntity1;
                if (((BigCannonBehavior)((Object)cannon.cannonBehavior())).tryLoadingBlock(blockInfo)) {
                    ((BigCannonBehavior)((Object)cannon.cannonBehavior())).blockEntity.notifyUpdate();
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    public static boolean customBlockRemoval(Contraption contraption, LevelAccessor levelAccessor, BlockPos pos, BlockState state) {
        BlockEntity blockEntity;
        BlockState intersectState;
        if (CBCModifiedContraptionRegistry.canLoadBigCannon(contraption) && (intersectState = levelAccessor.m_8055_(pos)).m_60734_() instanceof BigCannonBlock && (blockEntity = levelAccessor.m_7702_(pos)) instanceof IBigCannonBlockEntity) {
            IBigCannonBlockEntity cannon = (IBigCannonBlockEntity)blockEntity;
            if (state != intersectState) {
                ((BigCannonBehavior)((Object)cannon.cannonBehavior())).removeBlock();
                ((BigCannonBehavior)((Object)cannon.cannonBehavior())).blockEntity.notifyUpdate();
                return true;
            }
        }
        return false;
    }

    public static void customChecks(Contraption contraption, Level level, BlockPos pos, BlockState state, @Nullable Direction forcedDirection, Queue<BlockPos> frontier, Set<BlockPos> visited, CallbackInfoReturnable<Boolean> cir) {
        if (CBCBlocks.CANNON_MOUNT.has(state) || CBCBlocks.FIXED_CANNON_MOUNT.has(state) || CBCBlocks.CANNON_CARRIAGE.has(state)) {
            BlockPos assemblyPos = null;
            if (CBCBlocks.CANNON_MOUNT.has(state)) {
                Direction vertical = (Direction)state.m_61143_((Property)BlockStateProperties.f_155997_);
                assemblyPos = pos.m_5484_(vertical, -2);
            } else if (CBCBlocks.FIXED_CANNON_MOUNT.has(state)) {
                assemblyPos = pos.m_7494_();
            } else if (CBCBlocks.CANNON_CARRIAGE.has(state)) {
                assemblyPos = pos.m_7494_();
            }
            if (assemblyPos == null || level.m_151570_(assemblyPos)) {
                return;
            }
            BlockState state1 = level.m_8055_(assemblyPos);
            Block block = state1.m_60734_();
            if (!(block instanceof CannonContraptionProviderBlock)) {
                return;
            }
            CannonContraptionProviderBlock provider = (CannonContraptionProviderBlock)block;
            Direction facing = provider.getFacing(state1);
            if (CBCBlocks.CANNON_MOUNT.has(state) && facing.m_122434_().m_122479_() && facing.m_122434_() != ((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_)).m_122434_()) {
                return;
            }
            if (CBCBlocks.CANNON_CARRIAGE.has(state) && facing.m_122434_().m_122479_() && facing.m_122434_() != ((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_)).m_122434_()) {
                return;
            }
            if (CBCModifiedContraptionRegistry.canLoadBigCannon(contraption)) {
                ContraptionRemix.simpleMarking((Contraption)((CanLoadBigCannon)contraption), level, assemblyPos, Direction.DOWN, forcedDirection);
            }
            frontier.add(assemblyPos);
        }
    }

    public static <T extends Contraption> void simpleMarking(T contraption, Level level, BlockPos pos, Direction attached, @Nullable Direction forcedDirection) {
        BigCannonBlock cBlock;
        if (forcedDirection == null) {
            return;
        }
        BlockPos local = ((CanLoadBigCannon)contraption).createbigcannons$toLocalPos(pos);
        BlockState state = level.m_8055_(pos);
        Block block = state.m_60734_();
        if (block instanceof BigCannonBlock && ((cBlock = (BigCannonBlock)block).getFacing(state).m_122434_() != attached.m_122434_() || cBlock.getFacing(state).m_122434_() != forcedDirection.m_122434_())) {
            StructureTemplate.StructureBlockInfo oldInfo;
            if (!contraption.getBlocks().containsKey(local)) {
                contraption.getBlocks().put(local, new StructureTemplate.StructureBlockInfo(BlockPos.f_121853_, Blocks.f_50016_.m_49966_(), null));
            }
            if ((oldInfo = (StructureTemplate.StructureBlockInfo)contraption.getBlocks().get(local)).f_74676_().m_60734_() instanceof BigCannonBlock) {
                return;
            }
            CompoundTag tag = oldInfo.f_74677_() == null ? new CompoundTag() : oldInfo.f_74677_().m_6426_();
            tag.m_128379_("createbigcannons:add_as_cannon", true);
            contraption.getBlocks().put(local, new StructureTemplate.StructureBlockInfo(oldInfo.f_74675_(), oldInfo.f_74676_(), tag));
        } else if (IBigCannonBlockEntity.isValidMunitionState(forcedDirection.m_122434_(), state) && forcedDirection.m_122434_() != attached.m_122434_()) {
            ContraptionRemix.addPosToCannonColliders(contraption, local, forcedDirection);
        }
    }

    public static <T extends Contraption> void stickerMarking(T contraption, Level level, BlockPos pos, Direction attached, @Nullable Direction forcedDirection) {
        if (!BlockMovementChecks.isNotSupportive((BlockState)level.m_8055_(pos), (Direction)attached.m_122424_())) {
            ContraptionRemix.simpleMarking(contraption, level, pos, attached, forcedDirection);
        }
    }

    public static <T extends Contraption> void pistonMarking(T contraption, Level level, BlockPos pos, BlockState state) {
        Direction forcedDirection = ((CanLoadBigCannon)contraption).createbigcannons$getAssemblyMovementDirection(level);
        Direction direction = (Direction)state.m_61143_((Property)BlockStateProperties.f_61372_);
        BlockPos offset = pos.m_121945_(direction);
        if (!(forcedDirection != null && forcedDirection == direction || MechanicalPistonBlock.isStickyPiston((BlockState)state))) {
            return;
        }
        ContraptionRemix.simpleMarking(contraption, level, offset, direction, forcedDirection);
    }

    public static <T extends Contraption> void pistonHeadMarking(T contraption, Level level, BlockPos pos, BlockState state) {
        Direction forcedDirection = ((CanLoadBigCannon)contraption).createbigcannons$getAssemblyMovementDirection(level);
        Direction direction = (Direction)state.m_61143_((Property)BlockStateProperties.f_61372_);
        BlockPos offset = pos.m_121945_(direction);
        if ((forcedDirection == null || forcedDirection != direction) && state.m_61143_((Property)MechanicalPistonHeadBlock.TYPE) != PistonType.STICKY) {
            return;
        }
        ContraptionRemix.simpleMarking(contraption, level, offset, direction, forcedDirection);
    }

    public static <T extends Contraption> void gantryCarriageMarking(T contraption, Level level, BlockPos pos, BlockState state) {
        Direction forcedDirection = ((CanLoadBigCannon)contraption).createbigcannons$getAssemblyMovementDirection(level);
        Direction direction = (Direction)state.m_61143_((Property)BlockStateProperties.f_61372_);
        BlockPos offset = pos.m_121945_(direction);
        ContraptionRemix.simpleMarking(contraption, level, offset, direction, forcedDirection);
    }

    public static <T extends Contraption> void chassisMarking(T contraption, Level level, List<BlockPos> addedPositions, Queue<BlockPos> frontier, Set<BlockPos> visited, @Nullable Direction forcedDirection, ChassisBlockEntity chassisBE) {
        if (forcedDirection == null) {
            return;
        }
        Direction.Axis forcedAxis = forcedDirection.m_122434_();
        HashSet<BlockPos> positionSet = new HashSet<BlockPos>(addedPositions);
        HashSet<BlockPos> firstCannonBlocks = new HashSet<BlockPos>();
        HashSet<BlockPos> finalCannonBlocks = new HashSet<BlockPos>();
        HashSet<BlockPos> recheckPositions = new HashSet<BlockPos>();
        BlockPos rootPos = chassisBE.m_58899_();
        positionSet.remove(rootPos);
        block0: for (BlockPos pos : positionSet) {
            int n;
            BlockPos local = ((CanLoadBigCannon)contraption).createbigcannons$toLocalPos(pos);
            BlockState state = level.m_8055_(pos);
            Block block = state.m_60734_();
            if (block instanceof BigCannonBlock) {
                BigCannonBlock cBlock = (BigCannonBlock)block;
                block = level.m_7702_(pos);
                if (block instanceof IBigCannonBlockEntity) {
                    IBigCannonBlockEntity cbe = (IBigCannonBlockEntity)block;
                    if (cBlock.getFacing(state).m_122434_() != forcedAxis) {
                        finalCannonBlocks.add(pos);
                        continue;
                    }
                    boolean addAsCannon = ((BigCannonBehavior)((Object)cbe.cannonBehavior())).block().f_74676_().m_60795_();
                    if (!addAsCannon) {
                        Direction[] directionArray = Iterate.directions;
                        n = directionArray.length;
                        for (int i = 0; i < n; ++i) {
                            Direction dir1 = directionArray[i];
                            BlockPos offset = pos.m_121945_(dir1);
                            if (!rootPos.equals((Object)offset) && !positionSet.contains(offset) || dir1.m_122434_() == forcedAxis && !firstCannonBlocks.contains(offset)) continue;
                            addAsCannon = true;
                            break;
                        }
                    }
                    if (addAsCannon) {
                        firstCannonBlocks.add(pos);
                        continue;
                    }
                    recheckPositions.add(pos);
                    continue;
                }
            }
            if (!IBigCannonBlockEntity.isValidMunitionState(forcedAxis, state)) continue;
            Direction[] addAsCannon = Iterate.directions;
            int n2 = addAsCannon.length;
            for (n = 0; n < n2; ++n) {
                BlockPos offset;
                Direction dir1 = addAsCannon[n];
                if (dir1.m_122434_() == forcedAxis || !rootPos.equals((Object)(offset = pos.m_121945_(dir1))) && !positionSet.contains(offset)) continue;
                ContraptionRemix.addPosToCannonColliders(contraption, local, forcedDirection);
                continue block0;
            }
        }
        HashSet<BlockPos> localVisited = new HashSet<BlockPos>();
        LinkedList<BlockPos> localFrontier = new LinkedList<BlockPos>(firstCannonBlocks);
        for (int i = 0; i < 300 && !localFrontier.isEmpty(); ++i) {
            BigCannonBlock cBlock;
            BlockPos pos = (BlockPos)localFrontier.poll();
            if (localVisited.contains(pos)) continue;
            localVisited.add(pos);
            finalCannonBlocks.add(pos);
            BlockState state = level.m_8055_(pos);
            Direction[] addAsCannon = state.m_60734_();
            if (!(addAsCannon instanceof BigCannonBlock) || (cBlock = (BigCannonBlock)addAsCannon).getFacing(state).m_122434_() != forcedAxis) continue;
            for (Direction dir : Iterate.directionsInAxis((Direction.Axis)forcedAxis)) {
                BlockPos offsetPos = pos.m_121945_(dir);
                if (!recheckPositions.contains(offsetPos) || localVisited.contains(offsetPos)) continue;
                localFrontier.add(offsetPos);
            }
        }
        for (BlockPos pos : finalCannonBlocks) {
            StructureTemplate.StructureBlockInfo oldInfo;
            BlockPos local = ((CanLoadBigCannon)contraption).createbigcannons$toLocalPos(pos);
            if (!contraption.getBlocks().containsKey(local)) {
                contraption.getBlocks().put(local, new StructureTemplate.StructureBlockInfo(BlockPos.f_121853_, Blocks.f_50016_.m_49966_(), null));
            }
            if ((oldInfo = (StructureTemplate.StructureBlockInfo)contraption.getBlocks().get(local)).f_74676_().m_60734_() instanceof BigCannonBlock) continue;
            CompoundTag tag = oldInfo.f_74677_() == null ? new CompoundTag() : oldInfo.f_74677_().m_6426_();
            tag.m_128379_("createbigcannons:add_as_cannon", true);
            contraption.getBlocks().put(local, new StructureTemplate.StructureBlockInfo(oldInfo.f_74675_(), oldInfo.f_74676_(), tag));
        }
    }

    public static <T extends Contraption> void moveLoaderBlocks(T contraption, Level level, @Nullable Direction forcedDirection, Queue<BlockPos> frontier, Set<BlockPos> visited, BlockPos pos, BlockState state) {
        IBigCannonBlockEntity cbe;
        StructureTemplate.StructureBlockInfo blockInfo;
        BlockEntity be = level.m_7702_(pos);
        if ((state = IBigCannonBlockEntity.getInnerCannonBlockState(level, pos, state)).m_60734_() instanceof BigCannonBlock && be instanceof IBigCannonBlockEntity && !(blockInfo = ((BigCannonBehavior)((Object)(cbe = (IBigCannonBlockEntity)be).cannonBehavior())).block()).f_74676_().m_60795_()) {
            state = blockInfo.f_74676_();
        }
        if (CBCBlocks.WORM_HEAD.has(state) && forcedDirection != null && state.m_61143_((Property)BlockStateProperties.f_61372_) == forcedDirection.m_122424_()) {
            BigCannonMunitionBlock mBlock;
            Block block;
            IBigCannonBlockEntity cbe2;
            StructureTemplate.StructureBlockInfo containedInfo;
            BigCannonBlock cBlock;
            Direction facing = (Direction)state.m_61143_((Property)BlockStateProperties.f_61372_);
            BlockPos offset = pos.m_121945_(facing);
            BlockState offsetState = level.m_8055_(offset);
            Block block2 = offsetState.m_60734_();
            if (block2 instanceof BigCannonBlock && (cBlock = (BigCannonBlock)block2).getFacing(offsetState).m_122434_() == facing.m_122434_() && (block2 = level.m_7702_(offset)) instanceof IBigCannonBlockEntity && (containedInfo = ((BigCannonBehavior)((Object)(cbe2 = (IBigCannonBlockEntity)block2).cannonBehavior())).block()).f_74676_().m_60734_() instanceof BigCannonMunitionBlock) {
                offsetState = containedInfo.f_74676_();
            }
            if ((block = offsetState.m_60734_()) instanceof BigCannonMunitionBlock && (mBlock = (BigCannonMunitionBlock)block).getAxis(offsetState) == forcedDirection.m_122434_()) {
                frontier.add(offset);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static <T extends Contraption> boolean getStickFlag(T contraption, Level level, BlockPos pos, BlockPos offsetPos, BlockState state, BlockState offsetState, Direction offset, @Nullable Direction forcedDirection, boolean blockAttachedTowardsFace) {
        IBigCannonBlockEntity cbe;
        BigCannonBlock cBlock;
        Block block;
        boolean push;
        BigCannonBlock cBlock2;
        boolean brittle;
        boolean canStick;
        Block prevPos;
        if (blockAttachedTowardsFace) {
            BigCannonBlock cBlock1;
            StructureTemplate.StructureBlockInfo info;
            BigCannonBlock cBlock3;
            StructureTemplate.StructureBlockInfo offsetInfo;
            BlockPos localOffsetPos = ((CanLoadBigCannon)contraption).createbigcannons$toLocalPos(offsetPos);
            if (contraption.getBlocks().containsKey(localOffsetPos) && BlockMovementChecks.isBlockAttachedTowards((BlockState)(offsetInfo = (StructureTemplate.StructureBlockInfo)contraption.getBlocks().get(localOffsetPos)).f_74676_(), (Level)level, (BlockPos)offsetPos, (Direction)offset.m_122424_())) {
                return true;
            }
            Direction.Axis offsetAxis = offset.m_122434_();
            Block block2 = offsetState.m_60734_();
            if (!(block2 instanceof BigCannonBlock) || (cBlock3 = (BigCannonBlock)block2).getFacing(offsetState).m_122434_() != offsetAxis || !((block2 = level.m_7702_(offsetPos)) instanceof IBigCannonBlockEntity)) return true;
            IBigCannonBlockEntity cbe2 = (IBigCannonBlockEntity)block2;
            BlockPos localPos = ((CanLoadBigCannon)contraption).createbigcannons$toLocalPos(pos);
            if (contraption.getBlocks().containsKey(localPos) && (info = (StructureTemplate.StructureBlockInfo)contraption.getBlocks().get(localPos)).f_74677_() != null && info.f_74677_().m_128441_("createbigcannons:add_as_cannon")) {
                return true;
            }
            StructureTemplate.StructureBlockInfo offsetInfo2 = ((BigCannonBehavior)((Object)cbe2.cannonBehavior())).block();
            prevPos = pos.m_121945_(offset.m_122424_());
            BlockPos localPrev = ((CanLoadBigCannon)contraption).createbigcannons$toLocalPos((BlockPos)prevPos);
            StructureTemplate.StructureBlockInfo prevInfo = null;
            if (contraption.getBlocks().containsKey(localPrev)) {
                prevInfo = (StructureTemplate.StructureBlockInfo)contraption.getBlocks().get(localPrev);
            } else if (contraption instanceof PulleyContraption && pos.equals((Object)contraption.anchor) && offset == Direction.DOWN) {
                prevInfo = new StructureTemplate.StructureBlockInfo(BlockPos.f_121853_, AllBlocks.PULLEY_MAGNET.getDefaultState(), null);
            }
            BlockState currentState = state;
            Block block3 = state.m_60734_();
            if (block3 instanceof BigCannonBlock && (cBlock1 = (BigCannonBlock)block3).getFacing(state).m_122434_() == offsetAxis && (block3 = level.m_7702_(pos)) instanceof IBigCannonBlockEntity) {
                IBigCannonBlockEntity cbe1 = (IBigCannonBlockEntity)block3;
                currentState = ((BigCannonBehavior)((Object)cbe1.cannonBehavior())).block().f_74676_();
            }
            if (!IBigCannonBlockEntity.isValidMunitionState(offsetAxis, currentState) || prevInfo == null || !IBigCannonBlockEntity.isValidMunitionState(offsetAxis, prevInfo.f_74676_())) return true;
            if (BlockMovementChecks.isBlockAttachedTowards((BlockState)offsetInfo2.f_74676_(), (Level)level, (BlockPos)offsetPos, (Direction)offset.m_122424_())) {
                return true;
            }
        }
        boolean bl = canStick = !(brittle = BlockMovementChecks.isBrittle((BlockState)offsetState)) && ContraptionRemix.canStickTo(state, offsetState) && ContraptionRemix.canStickTo(offsetState, state);
        if (canStick) {
            if (state.m_60811_() == PushReaction.PUSH_ONLY || offsetState.m_60811_() == PushReaction.PUSH_ONLY) {
                canStick = false;
            }
            if (BlockMovementChecks.isNotSupportive((BlockState)state, (Direction)offset)) {
                canStick = false;
            }
            if (BlockMovementChecks.isNotSupportive((BlockState)offsetState, (Direction)offset.m_122424_())) {
                canStick = false;
            }
        }
        if (canStick) {
            return true;
        }
        if (forcedDirection == null) {
            return false;
        }
        Direction.Axis forcedAxis = forcedDirection.m_122434_();
        BlockState pushState = offsetState;
        prevPos = offsetState.m_60734_();
        if (prevPos instanceof BigCannonBlock && (cBlock2 = (BigCannonBlock)prevPos).getFacing(offsetState).m_122434_() == forcedAxis && (prevPos = level.m_7702_(offsetPos)) instanceof IBigCannonBlockEntity) {
            IBigCannonBlockEntity cbe3 = (IBigCannonBlockEntity)prevPos;
            pushState = ((BigCannonBehavior)((Object)cbe3.cannonBehavior())).block().f_74676_();
        }
        boolean bl2 = push = offset == forcedDirection && !BlockMovementChecks.isNotSupportive((BlockState)state, (Direction)forcedDirection);
        if ((contraption instanceof GantryContraption || contraption instanceof PulleyContraption && !push) && !IBigCannonBlockEntity.isValidMunitionState(forcedAxis, pushState)) {
            return false;
        }
        if (!push || blockAttachedTowardsFace || !((block = offsetState.m_60734_()) instanceof BigCannonBlock) || (cBlock = (BigCannonBlock)block).getFacing(offsetState).m_122434_() != forcedAxis || !((block = level.m_7702_(offsetPos)) instanceof IBigCannonBlockEntity) || !(cbe = (IBigCannonBlockEntity)block).canLoadBlock(new StructureTemplate.StructureBlockInfo(BlockPos.f_121853_, state, null))) return push;
        return false;
    }

    public static <T extends Contraption> boolean handleCannonFrontier(T contraption, Level level, BlockPos pos, BlockPos offsetPos, Set<BlockPos> visited, Direction offset, @Nullable Direction forcedDirection, boolean stickFlag) {
        BigCannonBlock cBlock;
        if (forcedDirection == null) {
            return false;
        }
        BlockState state = level.m_8055_(pos);
        BlockPos localPos = ((CanLoadBigCannon)contraption).createbigcannons$toLocalPos(pos);
        BlockState offsetState = level.m_8055_(offsetPos);
        BlockEntity offsetBE = level.m_7702_(offsetPos);
        BlockPos localOffset = ((CanLoadBigCannon)contraption).createbigcannons$toLocalPos(offsetPos);
        boolean flag = !stickFlag;
        Direction.Axis forcedAxis = forcedDirection.m_122434_();
        Block block = offsetState.m_60734_();
        if (block instanceof BigCannonBlock && (cBlock = (BigCannonBlock)block).getFacing(offsetState).m_122434_() == forcedAxis && offsetBE instanceof IBigCannonBlockEntity) {
            IBigCannonBlockEntity cbe = (IBigCannonBlockEntity)offsetBE;
            if (forcedAxis != offset.m_122434_() && stickFlag) {
                StructureTemplate.StructureBlockInfo offsetInfo;
                if (!contraption.getBlocks().containsKey(localOffset)) {
                    contraption.getBlocks().put(localOffset, new StructureTemplate.StructureBlockInfo(localOffset, Blocks.f_50016_.m_49966_(), null));
                }
                CompoundTag tag = (offsetInfo = (StructureTemplate.StructureBlockInfo)contraption.getBlocks().get(localOffset)).f_74677_() == null ? new CompoundTag() : offsetInfo.f_74677_().m_6426_();
                tag.m_128379_("createbigcannons:add_as_cannon", true);
                contraption.getBlocks().put(localOffset, new StructureTemplate.StructureBlockInfo(offsetInfo.f_74675_(), offsetInfo.f_74676_(), tag));
            } else if (contraption.getBlocks().containsKey(localOffset) && !visited.contains(offsetPos)) {
                flag = !ContraptionRemix.shouldAddAsCannon(contraption, localPos);
            } else if (ContraptionRemix.shouldAddAsCannon(contraption, localPos)) {
                flag = false;
            } else {
                Block block2;
                BlockPos prevPos = pos.m_121945_(offset.m_122424_());
                BlockPos localPrev = ((CanLoadBigCannon)contraption).createbigcannons$toLocalPos(prevPos);
                StructureTemplate.StructureBlockInfo prevInfo = null;
                if (contraption.getBlocks().containsKey(localPrev)) {
                    prevInfo = (StructureTemplate.StructureBlockInfo)contraption.getBlocks().get(localPrev);
                } else if (contraption instanceof PulleyContraption && pos.equals((Object)contraption.anchor) && offset == Direction.DOWN) {
                    prevInfo = new StructureTemplate.StructureBlockInfo(BlockPos.f_121853_, AllBlocks.PULLEY_MAGNET.getDefaultState(), null);
                }
                if (!IBigCannonBlockEntity.isValidMunitionState(forcedAxis, state) && (block2 = state.m_60734_()) instanceof BigCannonBlock) {
                    BigCannonBlock cBlock1 = (BigCannonBlock)block2;
                    block2 = level.m_7702_(pos);
                    if (block2 instanceof IBigCannonBlockEntity) {
                        IBigCannonBlockEntity cbe1 = (IBigCannonBlockEntity)block2;
                        if (cBlock1.getFacing(state).m_122434_() == forcedAxis && prevInfo != null && stickFlag) {
                            BigCannonBlock cBlock2;
                            boolean prevMunition = IBigCannonBlockEntity.isValidMunitionState(forcedAxis, prevInfo.f_74676_());
                            Block block3 = prevInfo.f_74676_().m_60734_();
                            boolean alignedCannonBlock = block3 instanceof BigCannonBlock && (cBlock2 = (BigCannonBlock)block3).getFacing(prevInfo.f_74676_()).m_122434_() == forcedAxis;
                            BlockState innerState = ((BigCannonBehavior)((Object)cbe1.cannonBehavior())).block().f_74676_();
                            boolean filled = IBigCannonBlockEntity.isValidMunitionState(forcedAxis, innerState);
                            BlockState innerOffsetState = ((BigCannonBehavior)((Object)cbe.cannonBehavior())).block().f_74676_();
                            if (filled && (prevMunition || !alignedCannonBlock)) {
                                flag = !IBigCannonBlockEntity.isValidMunitionState(forcedAxis, innerOffsetState);
                            }
                            state = innerState;
                            offsetState = innerOffsetState;
                        }
                    }
                }
            }
        }
        if (IBigCannonBlockEntity.isValidMunitionState(forcedAxis, offsetState) && forcedAxis != offset.m_122434_() && stickFlag) {
            ContraptionRemix.addPosToCannonColliders(contraption, localOffset, forcedDirection);
        }
        offsetState = ContraptionRemix.getInnerCannonState((LevelAccessor)level, offsetState, offsetPos, forcedDirection);
        if (CBCBlocks.WORM_HEAD.has(state) && state.m_61143_((Property)BlockStateProperties.f_61372_) == forcedDirection && IBigCannonBlockEntity.isValidMunitionState(forcedAxis, offsetState)) {
            flag = true;
        }
        return flag;
    }

    @Nullable
    public static <T extends Contraption> Pair<StructureTemplate.StructureBlockInfo, BlockEntity> handleCapture(T contraption, Level level, BlockPos pos, Queue<BlockPos> frontier, Set<BlockPos> visited, Direction forcedDirection, Set<SuperGlueEntity> glueToRemove) {
        IBigCannonBlockEntity cbe;
        Direction.Axis forcedAxis;
        BlockPos localPos;
        block15: {
            block14: {
                localPos = ((CanLoadBigCannon)contraption).createbigcannons$toLocalPos(pos);
                if (ContraptionRemix.shouldAddAsCannon(contraption, localPos)) {
                    StructureTemplate.StructureBlockInfo info = (StructureTemplate.StructureBlockInfo)contraption.getBlocks().get(localPos);
                    if (info != null && info.f_74677_() != null) {
                        info.f_74677_().m_128473_("createbigcannons:add_as_cannon");
                    }
                    visited.add(pos);
                    return null;
                }
                if (forcedDirection == null) {
                    return null;
                }
                forcedAxis = forcedDirection.m_122434_();
                BlockState state = level.m_8055_(pos);
                BlockEntity be = level.m_7702_(pos);
                Block block = state.m_60734_();
                if (!(block instanceof BigCannonBlock)) break block14;
                BigCannonBlock cBlock = (BigCannonBlock)block;
                if (!(be instanceof IBigCannonBlockEntity)) break block14;
                cbe = (IBigCannonBlockEntity)be;
                if (cBlock.getFacing(state).m_122434_() == forcedAxis) break block15;
            }
            return null;
        }
        BigCannonBehavior behavior = (BigCannonBehavior)((Object)cbe.cannonBehavior());
        StructureTemplate.StructureBlockInfo currentInfo = behavior.block();
        BlockState addedState = currentInfo.f_74676_();
        for (Direction offset : Iterate.directions) {
            IBigCannonBlockEntity cbe1;
            Object cBlock1;
            Direction.Axis offsetAxis = offset.m_122434_();
            if (offsetAxis != forcedAxis) continue;
            BlockPos offsetPos = pos.m_121945_(offset);
            BlockPos localOffsetPos = ((CanLoadBigCannon)contraption).createbigcannons$toLocalPos(offsetPos);
            BlockState offsetState = level.m_8055_(offsetPos);
            if (contraption.getBlocks().containsKey(localOffsetPos)) {
                StructureTemplate.StructureBlockInfo offsetInfo = (StructureTemplate.StructureBlockInfo)contraption.getBlocks().get(localOffsetPos);
                Block block = offsetInfo.f_74676_().m_60734_();
                if (block instanceof BigCannonBlock && (cBlock1 = (BigCannonBlock)block).getFacing(offsetInfo.f_74676_()).m_122434_() == forcedAxis) {
                    if (!visited.contains(offsetPos)) {
                        frontier.remove(offsetPos);
                        continue;
                    }
                    if (!behavior.isConnectedTo(offset)) continue;
                    return null;
                }
                if (offset != forcedDirection.m_122424_() || IBigCannonBlockEntity.isValidMunitionState(forcedAxis, offsetInfo)) continue;
                return null;
            }
            if (!frontier.contains(offsetPos) || !(offsetState.m_60734_() instanceof BigCannonBlock) || !((cBlock1 = level.m_7702_(offsetPos)) instanceof IBigCannonBlockEntity) || !((BigCannonBehavior)((Object)(cbe1 = (IBigCannonBlockEntity)cBlock1).cannonBehavior())).isConnectedTo(offset.m_122424_())) continue;
            BlockPos prevLocalPos = localPos.m_121945_(offset.m_122424_());
            if (!contraption.getBlocks().containsKey(prevLocalPos)) continue;
            StructureTemplate.StructureBlockInfo otherInfo = ((BigCannonBehavior)((Object)cbe1.cannonBehavior())).block();
            BlockState otherState = otherInfo.f_74676_();
            StructureTemplate.StructureBlockInfo prevInfo = (StructureTemplate.StructureBlockInfo)contraption.getBlocks().get(prevLocalPos);
            if (!IBigCannonBlockEntity.isValidMunitionState(offsetAxis, prevInfo) && (prevInfo.f_74676_().m_60734_() instanceof BigCannonBlock || addedState.m_60795_() || offset == forcedDirection)) {
                return null;
            }
            if (addedState.m_60795_() || otherState.m_60795_() || !ContraptionRemix.isAttachedCapture(level, offset, pos, offsetPos, addedState, otherState, forcedDirection, glueToRemove)) {
                frontier.remove(offsetPos);
            }
            if (!CBCBlocks.WORM_HEAD.has(addedState) || !IBigCannonBlockEntity.isValidMunitionState(forcedDirection.m_122434_(), otherState)) continue;
            Direction facing = (Direction)addedState.m_61143_((Property)BlockStateProperties.f_61372_);
            if (facing == forcedDirection.m_122424_()) {
                frontier.add(offsetPos);
                continue;
            }
            frontier.remove(offsetPos);
        }
        if (addedState.m_60795_()) {
            return null;
        }
        visited.remove(pos);
        CompoundTag tag = currentInfo.f_74677_() == null ? null : currentInfo.f_74677_().m_6426_();
        BlockEntity newBe = tag != null && tag.m_128425_("id", 8) ? BlockEntity.m_155241_((BlockPos)currentInfo.f_74675_(), (BlockState)currentInfo.f_74676_(), (CompoundTag)tag) : null;
        return Pair.of((Object)new StructureTemplate.StructureBlockInfo(currentInfo.f_74675_(), currentInfo.f_74676_(), tag), (Object)newBe);
    }

    private static boolean isAttachedCapture(Level level, Direction offset, BlockPos pos, BlockPos offsetPos, BlockState state, BlockState offsetState, Direction forcedDirection, Set<SuperGlueEntity> glueToRemove) {
        boolean canStick;
        if (SuperGlueEntity.isGlued((LevelAccessor)level, (BlockPos)pos, (Direction)offset, glueToRemove)) {
            return true;
        }
        if (BlockMovementChecks.isBlockAttachedTowards((BlockState)offsetState, (Level)level, (BlockPos)offsetPos, (Direction)offset.m_122424_())) {
            return true;
        }
        boolean brittle = BlockMovementChecks.isBrittle((BlockState)offsetState);
        boolean bl = canStick = !brittle && ContraptionRemix.canStickTo(offsetState, state) && ContraptionRemix.canStickTo(state, offsetState);
        if (canStick) {
            if (state.m_60811_() == PushReaction.PUSH_ONLY || offsetState.m_60811_() == PushReaction.PUSH_ONLY) {
                canStick = false;
            }
            if (BlockMovementChecks.isNotSupportive((BlockState)state, (Direction)offset)) {
                canStick = false;
            }
            if (BlockMovementChecks.isNotSupportive((BlockState)offsetState, (Direction)offset.m_122424_())) {
                canStick = false;
            }
        }
        if (canStick) {
            return true;
        }
        return offset == forcedDirection && !BlockMovementChecks.isNotSupportive((BlockState)state, (Direction)forcedDirection);
    }

    public static boolean isLoadingCannon(Level level, BlockPos colliderPos, Direction movementDirection, BlockState collidedState, StructureTemplate.StructureBlockInfo blockInfo) {
        IBigCannonBlockEntity cbe;
        BigCannonBlock cannonBlock;
        Block block = collidedState.m_60734_();
        return block instanceof BigCannonBlock && (cannonBlock = (BigCannonBlock)block).getFacing(collidedState).m_122434_() == movementDirection.m_122434_() && (block = level.m_7702_(colliderPos)) instanceof IBigCannonBlockEntity && ((BigCannonBehavior)((Object)(cbe = (IBigCannonBlockEntity)block).cannonBehavior())).canLoadBlock(blockInfo);
    }

    public static <T extends Contraption> void markFragileBlocks(T contraption) {
        Set<BlockPos> fragileBlocks = ((HasFragileContraption)contraption).createbigcannons$getFragileBlockPositions();
        fragileBlocks.clear();
        for (Map.Entry info : contraption.getBlocks().entrySet()) {
            if (!IBigCannonBlockEntity.isValidMunitionState(null, (StructureTemplate.StructureBlockInfo)info.getValue())) continue;
            fragileBlocks.add((BlockPos)info.getKey());
        }
    }

    public static <T extends Contraption> void writeFragileBlocks(T contraption, CompoundTag tag) {
        ListTag fragileList = new ListTag();
        for (BlockPos p : ((HasFragileContraption)contraption).createbigcannons$getFragileBlockPositions()) {
            fragileList.add((Object)LongTag.m_128882_((long)p.m_121878_()));
        }
        tag.m_128365_("createbigcannons:fragile_blocks", (Tag)fragileList);
    }

    public static <T extends Contraption> void writeCannonLoaderData(T contraption, CompoundTag tag) {
        ListTag cannonColliderList = new ListTag();
        for (BlockPos p : ((CanLoadBigCannon)contraption).createbigcannons$getCannonLoadingColliders()) {
            cannonColliderList.add((Object)LongTag.m_128882_((long)p.m_121878_()));
        }
        tag.m_128365_("createbigcannons:cannon_loading_colliders", (Tag)cannonColliderList);
    }

    public static <T extends Contraption> void readFragileBlocks(T contraption, CompoundTag tag) {
        Set<BlockPos> fragileBlocks = ((HasFragileContraption)contraption).createbigcannons$getFragileBlockPositions();
        fragileBlocks.clear();
        for (Tag t : tag.m_128437_("createbigcannons:fragile_blocks", 4)) {
            if (t.m_6458_() != LongTag.f_128873_) continue;
            fragileBlocks.add(BlockPos.m_122022_((long)((LongTag)t).m_7046_()));
        }
    }

    public static <T extends Contraption> void readCannonLoaderData(T contraption, CompoundTag tag) {
        Set<BlockPos> cannonColliders = ((CanLoadBigCannon)contraption).createbigcannons$getCannonLoadingColliders();
        cannonColliders.clear();
        for (Tag t : tag.m_128437_("createbigcannons:cannon_loading_colliders", 4)) {
            if (t.m_6458_() != LongTag.f_128873_) continue;
            cannonColliders.add(BlockPos.m_122022_((long)((LongTag)t).m_7046_()));
        }
    }

    public static <T extends Contraption> void addPosToCannonColliders(T contraption, BlockPos pos, Direction dir) {
        Set<BlockPos> colliders = ((CanLoadBigCannon)contraption).createbigcannons$getCannonLoadingColliders();
        if (colliders.contains(pos.m_121945_(dir))) {
            return;
        }
        colliders.remove(pos.m_121945_(dir.m_122424_()));
        colliders.add(pos);
    }

    public static void removeInnerStateRopes(Level level, BlockPos pos, boolean isMoving) {
        BigCannonBlock cBlock;
        BlockState state = level.m_8055_(pos);
        Block block = state.m_60734_();
        if (block instanceof BigCannonBlock && (cBlock = (BigCannonBlock)block).getFacing(state).m_122434_().m_122478_() && (block = level.m_7702_(pos)) instanceof IBigCannonBlockEntity) {
            IBigCannonBlockEntity cbe = (IBigCannonBlockEntity)block;
            BlockState innerState = ((BigCannonBehavior)((Object)cbe.cannonBehavior())).block().f_74676_();
            if (!AllBlocks.ROPE.has(innerState) && !AllBlocks.PULLEY_MAGNET.has(innerState)) {
                return;
            }
            ((BigCannonBehavior)((Object)cbe.cannonBehavior())).removeBlock();
            ((BigCannonBehavior)((Object)cbe.cannonBehavior())).blockEntity.notifyUpdate();
            innerState.m_60753_(level, pos, Blocks.f_50016_.m_49966_(), isMoving);
            SoundType soundtype = innerState.m_60827_();
            level.m_5594_(null, pos, soundtype.m_56775_(), SoundSource.BLOCKS, (soundtype.m_56773_() + 1.0f) / 2.0f, soundtype.m_56774_() * 0.8f);
        }
    }

    public static boolean shouldAddAsCannon(Contraption contraption, BlockPos localPos) {
        Map blocks = contraption.getBlocks();
        if (!blocks.containsKey(localPos)) {
            return false;
        }
        StructureTemplate.StructureBlockInfo info = (StructureTemplate.StructureBlockInfo)blocks.get(localPos);
        return info.f_74677_() != null && info.f_74677_().m_128441_("createbigcannons:add_as_cannon");
    }

    public static void pulleyChecks(PulleyContraption contraption, Level level, BlockPos pos, @Nullable Direction forcedDirection, Queue<BlockPos> frontier) {
        IBigCannonBlockEntity cbe;
        BigCannonBlock cBlock;
        BlockState offsetState;
        Block block;
        BigCannonBlock cBlock2;
        BlockState state;
        BlockState pulledState = state = level.m_8055_(pos);
        Block block2 = state.m_60734_();
        if (block2 instanceof BigCannonBlock && (cBlock2 = (BigCannonBlock)block2).getFacing(state).m_122434_().m_122478_() && (block2 = level.m_7702_(pos)) instanceof IBigCannonBlockEntity) {
            IBigCannonBlockEntity cbe2 = (IBigCannonBlockEntity)block2;
            BlockState innerState = ((BigCannonBehavior)((Object)cbe2.cannonBehavior())).block().f_74676_();
            if (innerState.m_60795_()) {
                frontier.remove(pos);
                return;
            }
            pulledState = innerState;
        }
        if (forcedDirection == Direction.UP && (block = (offsetState = level.m_8055_(pos.m_7494_())).m_60734_()) instanceof BigCannonBlock && (cBlock = (BigCannonBlock)block).getFacing(offsetState).m_122434_().m_122478_() && (block = level.m_7702_(pos.m_7494_())) instanceof IBigCannonBlockEntity && !(cbe = (IBigCannonBlockEntity)block).canPushBlock(new StructureTemplate.StructureBlockInfo(BlockPos.f_121853_, pulledState, null))) {
            frontier.remove(pos);
        }
    }

    public static BlockState getInnerCannonState(LevelAccessor level, BlockState state, BlockPos pos, @Nullable Direction direction) {
        Block block = state.m_60734_();
        if (block instanceof BigCannonBlock) {
            BigCannonBlock cBlock = (BigCannonBlock)block;
            if ((direction == null || cBlock.getFacing(state).m_122434_() == direction.m_122434_()) && (block = level.m_7702_(pos)) instanceof IBigCannonBlockEntity) {
                IBigCannonBlockEntity cbe = (IBigCannonBlockEntity)block;
                StructureTemplate.StructureBlockInfo info = ((BigCannonBehavior)((Object)cbe.cannonBehavior())).block();
                return info.f_74676_();
            }
        }
        return state;
    }

    public static boolean removeCannonContentsOnBreak(Level level, BlockPos pos, boolean drops) {
        BlockEntity be = level.m_7702_(pos);
        if (!(be instanceof IBigCannonBlockEntity)) {
            return false;
        }
        IBigCannonBlockEntity cbe = (IBigCannonBlockEntity)be;
        StructureTemplate.StructureBlockInfo info = ((BigCannonBehavior)((Object)cbe.cannonBehavior())).block();
        ((BigCannonBehavior)((Object)cbe.cannonBehavior())).removeBlock();
        ((BigCannonBehavior)((Object)cbe.cannonBehavior())).blockEntity.notifyUpdate();
        info.f_74676_().m_60753_(level, pos, Blocks.f_50016_.m_49966_(), false);
        if (drops) {
            Block.m_49881_((BlockState)info.f_74676_(), (Level)level, (BlockPos)pos, null, null, (ItemStack)ItemStack.f_41583_);
        }
        SoundType soundtype = info.f_74676_().m_60827_();
        level.m_5594_(null, pos, soundtype.m_56775_(), SoundSource.BLOCKS, (soundtype.m_56773_() + 1.0f) / 2.0f, soundtype.m_56774_() * 0.8f);
        return true;
    }

    public static void validateCannonRope(Contraption contraption, Level level, @Nullable Direction direction, Function<BlockPos, BlockPos> toLocalPos) throws AssemblyException {
        if (CBCModifiedContraptionRegistry.canLoadBigCannon(contraption) && (direction == null || direction.m_122434_().m_122478_())) {
            return;
        }
        BlockPos diff = toLocalPos.apply(BlockPos.f_121853_).m_142393_(-1);
        HashSet<BlockPos> blocksToCheck = new HashSet<BlockPos>();
        for (Map.Entry entry : contraption.getBlocks().entrySet()) {
            BlockEntity blockEntity;
            BlockPos gpos = ((BlockPos)entry.getKey()).m_121955_((Vec3i)diff);
            BlockState levelState = level.m_8055_(gpos);
            StructureTemplate.StructureBlockInfo info = (StructureTemplate.StructureBlockInfo)entry.getValue();
            if (!(levelState.m_60734_() instanceof BigCannonBlock) || !((blockEntity = level.m_7702_(gpos)) instanceof IBigCannonBlockEntity)) continue;
            IBigCannonBlockEntity cbe = (IBigCannonBlockEntity)blockEntity;
            if (AllBlocks.ROPE.has(info.f_74676_()) || AllBlocks.PULLEY_MAGNET.has(info.f_74676_())) {
                throw AssemblyException.unmovableBlock((BlockPos)gpos, (BlockState)level.m_8055_(gpos));
            }
            StructureTemplate.StructureBlockInfo contained = ((BigCannonBehavior)((Object)cbe.cannonBehavior())).block();
            if (!AllBlocks.ROPE.has(contained.f_74676_()) && !AllBlocks.PULLEY_MAGNET.has(contained.f_74676_())) continue;
            blocksToCheck.add(gpos);
        }
        HashSet<BlockPos> checked = new HashSet<BlockPos>();
        int LIMIT = (Integer)AllConfigs.server().kinetics.maxRopeLength.get();
        block1: for (BlockPos pos : blocksToCheck) {
            if (checked.contains(pos)) continue;
            checked.add(pos);
            block2: for (Direction dir : Iterate.directionsInAxis((Direction.Axis)Direction.Axis.Y)) {
                for (int i = 1; i <= LIMIT; ++i) {
                    IBigCannonBlockEntity cbe;
                    BigCannonBlock cBlock;
                    BlockPos pos1 = pos.m_5484_(dir, i);
                    if (checked.contains(pos1)) continue block1;
                    checked.add(pos1);
                    BlockState state = level.m_8055_(pos1);
                    BlockState containedState = ContraptionRemix.getInnerCannonState((LevelAccessor)level, state, pos1, Direction.UP);
                    if (contraption.getBlocks().containsKey(pos1.m_121996_((Vec3i)diff))) {
                        if ((!AllBlocks.ROPE_PULLEY.has(containedState) || dir != Direction.UP) && (!AllBlocks.PULLEY_MAGNET.has(containedState) || dir != Direction.DOWN)) continue;
                        continue block2;
                    }
                    if (AllBlocks.ROPE_PULLEY.has(state) || AllBlocks.ROPE.has(containedState) || AllBlocks.PULLEY_MAGNET.has(containedState)) {
                        throw AssemblyException.unmovableBlock((BlockPos)pos1, (BlockState)level.m_8055_(pos1));
                    }
                    Block block = state.m_60734_();
                    if (!(block instanceof BigCannonBlock) || !(cBlock = (BigCannonBlock)block).getFacing(state).m_122434_().m_122478_() || !((block = level.m_7702_(pos1)) instanceof IBigCannonBlockEntity) || !((BigCannonBehavior)((Object)(cbe = (IBigCannonBlockEntity)block).cannonBehavior())).isConnectedTo(dir.m_122424_())) continue;
                    throw AssemblyException.unmovableBlock((BlockPos)pos1, (BlockState)level.m_8055_(pos1));
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean canStickTo(BlockState state, BlockState state1) {
        void var1_1;
        return ContraptionRemixImpl.canStickTo(state, (BlockState)var1_1);
    }
}

