/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.clockwork.content.kinetics.sequenced_seat;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;
import org.valkyrienskies.clockwork.content.kinetics.sequenced_seat.SequencedSeatBlockEntity;
import org.valkyrienskies.clockwork.content.kinetics.sequenced_seat.SequencedSeatRuleList;
import org.valkyrienskies.clockwork.platform.api.network.C2SCWPacket;
import org.valkyrienskies.clockwork.platform.api.network.ServerNetworkContext;
import org.valkyrienskies.clockwork.util.ClockworkConstants;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0011\b\u0016\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0014\u0010\nB\u0011\b\u0016\u0012\u0006\u0010\u0016\u001a\u00020\u0015\u00a2\u0006\u0004\b\u0014\u0010\u0017J\u0017\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0017\u0010\t\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\t\u0010\nR\u0014\u0010\f\u001a\u00020\u000b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\f\u0010\rR\u0014\u0010\u000f\u001a\u00020\u000e8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u000e8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0011\u0010\u0010R\u0014\u0010\u0012\u001a\u00020\u000e8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0012\u0010\u0010R\u0014\u0010\u0013\u001a\u00020\u000e8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0013\u0010\u0010\u00a8\u0006\u0018"}, d2={"Lorg/valkyrienskies/clockwork/content/kinetics/sequenced_seat/UpdateSeatRulesPacket;", "Lorg/valkyrienskies/clockwork/platform/api/network/C2SCWPacket;", "Lorg/valkyrienskies/clockwork/platform/api/network/ServerNetworkContext;", "context", "", "handle", "(Lorg/valkyrienskies/clockwork/platform/api/network/ServerNetworkContext;)V", "Lnet/minecraft/network/FriendlyByteBuf;", "buffer", "write", "(Lnet/minecraft/network/FriendlyByteBuf;)V", "Lnet/minecraft/core/BlockPos;", "pos", "Lnet/minecraft/core/BlockPos;", "Lorg/valkyrienskies/clockwork/content/kinetics/sequenced_seat/SequencedSeatRuleList;", "rulesBackward", "Lorg/valkyrienskies/clockwork/content/kinetics/sequenced_seat/SequencedSeatRuleList;", "rulesForward", "rulesLeft", "rulesRight", "<init>", "Lorg/valkyrienskies/clockwork/content/kinetics/sequenced_seat/SequencedSeatBlockEntity;", "be", "(Lorg/valkyrienskies/clockwork/content/kinetics/sequenced_seat/SequencedSeatBlockEntity;)V", "clockwork"})
public final class UpdateSeatRulesPacket
implements C2SCWPacket {
    @NotNull
    private final BlockPos pos;
    @NotNull
    private final SequencedSeatRuleList rulesForward;
    @NotNull
    private final SequencedSeatRuleList rulesBackward;
    @NotNull
    private final SequencedSeatRuleList rulesLeft;
    @NotNull
    private final SequencedSeatRuleList rulesRight;

    public UpdateSeatRulesPacket(@NotNull FriendlyByteBuf buffer) {
        CompoundTag nbt;
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        BlockPos blockPos = buffer.m_130135_();
        Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"readBlockPos(...)");
        this.pos = blockPos;
        this.rulesForward = new SequencedSeatRuleList();
        this.rulesBackward = new SequencedSeatRuleList();
        this.rulesLeft = new SequencedSeatRuleList();
        this.rulesRight = new SequencedSeatRuleList();
        CompoundTag compoundTag = nbt = buffer.m_130260_();
        Intrinsics.checkNotNull((Object)compoundTag);
        ListTag listTag = compoundTag.m_128437_("rulesForward", 10);
        Intrinsics.checkNotNullExpressionValue((Object)listTag, (String)"getList(...)");
        this.rulesForward.deserializeNBT(listTag);
        ListTag listTag2 = nbt.m_128437_("rulesBackward", 10);
        Intrinsics.checkNotNullExpressionValue((Object)listTag2, (String)"getList(...)");
        this.rulesBackward.deserializeNBT(listTag2);
        ListTag listTag3 = nbt.m_128437_("rulesLeft", 10);
        Intrinsics.checkNotNullExpressionValue((Object)listTag3, (String)"getList(...)");
        this.rulesLeft.deserializeNBT(listTag3);
        ListTag listTag4 = nbt.m_128437_("rulesRight", 10);
        Intrinsics.checkNotNullExpressionValue((Object)listTag4, (String)"getList(...)");
        this.rulesRight.deserializeNBT(listTag4);
    }

    public UpdateSeatRulesPacket(@NotNull SequencedSeatBlockEntity be) {
        Intrinsics.checkNotNullParameter((Object)((Object)be), (String)"be");
        BlockPos blockPos = be.m_58899_();
        Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"getBlockPos(...)");
        this.pos = blockPos;
        this.rulesForward = be.getForwardRules();
        this.rulesBackward = be.getBackwardRules();
        this.rulesLeft = be.getLeftRules();
        this.rulesRight = be.getRightRules();
    }

    @Override
    public void handle(@NotNull ServerNetworkContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        context.enqueueWork(() -> UpdateSeatRulesPacket.handle$lambda$0(context, this));
        context.setPacketHandled(true);
    }

    @Override
    public void write(@NotNull FriendlyByteBuf buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        buffer.m_130064_(this.pos);
        CompoundTag nbt = new CompoundTag();
        nbt.m_128365_(ClockworkConstants.Nbt.INSTANCE.getFORWARD_RULES(), (Tag)this.rulesForward.serializeNBT());
        nbt.m_128365_(ClockworkConstants.Nbt.INSTANCE.getBACKWARD_RULES(), (Tag)this.rulesBackward.serializeNBT());
        nbt.m_128365_(ClockworkConstants.Nbt.INSTANCE.getLEFT_RULES(), (Tag)this.rulesLeft.serializeNBT());
        nbt.m_128365_(ClockworkConstants.Nbt.INSTANCE.getRIGHT_RULES(), (Tag)this.rulesRight.serializeNBT());
        buffer.m_130079_(nbt);
    }

    private static final void handle$lambda$0(ServerNetworkContext $context, UpdateSeatRulesPacket this$0) {
        Intrinsics.checkNotNullParameter((Object)$context, (String)"$context");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        SequencedSeatBlockEntity be = (SequencedSeatBlockEntity)$context.getSender().m_9236_().m_7702_(this$0.pos);
        if (be != null && be.canPlayerUse((Player)$context.getSender())) {
            be.updateRules(this$0.rulesForward, this$0.rulesBackward, this$0.rulesLeft, this$0.rulesRight);
        }
    }
}

