/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.clockwork.platform.block_entity;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.valkyrienskies.clockwork.content.physicalities.ballast.BallastBlockEntity;

public class ForgeBallastBlockEntity
extends BallastBlockEntity {
    public ForgeBallastBlockEntity(@Nullable BlockEntityType<?> type, @Nullable BlockPos pos, @Nullable BlockState state) {
        super(type, pos, state);
        this.inventory = new ItemStackHandler(4){

            protected void onContentsChanged(int slot) {
                super.onContentsChanged(slot);
                ForgeBallastBlockEntity.this.recalculateWeightNextTick = true;
            }
        };
    }

    @Override
    protected void read(@NotNull CompoundTag compound, boolean clientPacket) {
        Object object;
        super.read(compound, clientPacket);
        if (!clientPacket && (object = this.inventory) instanceof ItemStackHandler) {
            ItemStackHandler ish = (ItemStackHandler)object;
            ish.deserializeNBT(compound.m_128469_("Inventory"));
        }
    }

    @Override
    protected void write(@NotNull CompoundTag compound, boolean clientPacket) {
        Object object;
        super.write(compound, clientPacket);
        if (!clientPacket && (object = this.inventory) instanceof ItemStackHandler) {
            ItemStackHandler ish = (ItemStackHandler)object;
            compound.m_128365_("Inventory", (Tag)ish.serializeNBT());
        }
    }

    @Override
    public void updateWeight() {
        this.oldWeight = this.newWeight;
        int maxCountItem = 256;
        int temp = 0;
        for (int i = 0; i < this.getInventoryOfBlock().getSlots(); ++i) {
            temp += this.getInventoryOfBlock().getStackInSlot(i).m_41613_();
        }
        this.newWeight = this.mapValue(temp, 0, maxCountItem, 0, 10000);
    }

    public ItemStackHandler getInventoryOfBlock() {
        return (ItemStackHandler)this.inventory;
    }
}

