/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.clockwork.util.render;

import com.jozufozu.flywheel.core.PartialModel;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.simibubi.create.foundation.item.render.PartialItemModelRenderer;
import com.simibubi.create.foundation.render.CachedBufferer;
import com.simibubi.create.foundation.render.SuperByteBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;
import org.valkyrienskies.clockwork.ClockworkMod;
import org.valkyrienskies.clockwork.ClockworkPartials;
import org.valkyrienskies.clockwork.ClockworkRenderTypes;
import org.valkyrienskies.clockwork.util.render.TransformData;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b-\u0010.JU\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0013\u0010\u0014J/\u0010\u0013\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0019J5\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0010\u00a2\u0006\u0004\b\u001c\u0010\u001dJ=\u0010\u001f\u001a\u00020\u00122\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0010\u00a2\u0006\u0004\b\u001f\u0010 JM\u0010\u001f\u001a\u00020\u00122\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020!2\u0006\u0010#\u001a\u00020\"2\u0006\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010$\u001a\u00020\u001a2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0010\u00a2\u0006\u0004\b\u001f\u0010%R\u0017\u0010'\u001a\u00020&8\u0006\u00a2\u0006\f\n\u0004\b'\u0010(\u001a\u0004\b)\u0010*R\u0017\u0010+\u001a\u00020&8\u0006\u00a2\u0006\f\n\u0004\b+\u0010(\u001a\u0004\b,\u0010*\u00a8\u0006/"}, d2={"Lorg/valkyrienskies/clockwork/util/render/RenderUtil;", "", "Lcom/mojang/blaze3d/vertex/PoseStack;", "matrices", "Lcom/jozufozu/flywheel/core/PartialModel;", "model", "Lnet/minecraft/client/renderer/RenderType;", "renderType", "Lcom/simibubi/create/foundation/item/render/PartialItemModelRenderer;", "renderer", "Lorg/joml/Vector3f;", "modelCorrection", "offset", "rotationVec", "", "scale", "", "light", "", "renderAndTransform", "(Lcom/mojang/blaze3d/vertex/PoseStack;Lcom/jozufozu/flywheel/core/PartialModel;Lnet/minecraft/client/renderer/RenderType;Lcom/simibubi/create/foundation/item/render/PartialItemModelRenderer;Lorg/joml/Vector3f;Lorg/joml/Vector3f;Lorg/joml/Vector3f;FI)V", "Lcom/simibubi/create/foundation/render/SuperByteBuffer;", "buffer", "coreOffset", "coreRotation", "(Lcom/simibubi/create/foundation/render/SuperByteBuffer;FLorg/joml/Vector3f;Lorg/joml/Vector3f;)Lcom/simibubi/create/foundation/render/SuperByteBuffer;", "Lorg/valkyrienskies/clockwork/util/render/TransformData;", "data", "renderCube", "(Lcom/mojang/blaze3d/vertex/PoseStack;Lcom/simibubi/create/foundation/item/render/PartialItemModelRenderer;Lorg/valkyrienskies/clockwork/util/render/TransformData;FI)V", "innerData", "renderCubeMatrix", "(Lcom/mojang/blaze3d/vertex/PoseStack;Lcom/simibubi/create/foundation/item/render/PartialItemModelRenderer;Lorg/valkyrienskies/clockwork/util/render/TransformData;Lorg/valkyrienskies/clockwork/util/render/TransformData;FI)V", "Lnet/minecraft/client/renderer/MultiBufferSource;", "Lnet/minecraft/world/level/block/state/BlockState;", "blockState", "outerData", "(Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;Lnet/minecraft/world/level/block/state/BlockState;Lorg/valkyrienskies/clockwork/util/render/TransformData;Lorg/valkyrienskies/clockwork/util/render/TransformData;Lorg/valkyrienskies/clockwork/util/render/TransformData;FI)V", "Lnet/minecraft/resources/ResourceLocation;", "CRYSTAL_MATRIX", "Lnet/minecraft/resources/ResourceLocation;", "getCRYSTAL_MATRIX", "()Lnet/minecraft/resources/ResourceLocation;", "PURPLE_HUE", "getPURPLE_HUE", "<init>", "()V", "clockwork"})
public final class RenderUtil {
    @NotNull
    public static final RenderUtil INSTANCE = new RenderUtil();
    @NotNull
    private static final ResourceLocation CRYSTAL_MATRIX = ClockworkMod.asResource("textures/block/empty.png");
    @NotNull
    private static final ResourceLocation PURPLE_HUE = ClockworkMod.asResource("textures/block/purple_hue.png");

    private RenderUtil() {
    }

    @NotNull
    public final ResourceLocation getCRYSTAL_MATRIX() {
        return CRYSTAL_MATRIX;
    }

    @NotNull
    public final ResourceLocation getPURPLE_HUE() {
        return PURPLE_HUE;
    }

    public final void renderCubeMatrix(@NotNull PoseStack matrices, @NotNull PartialItemModelRenderer renderer, @NotNull TransformData innerData, @NotNull TransformData data, float scale, int light) {
        Intrinsics.checkNotNullParameter((Object)matrices, (String)"matrices");
        Intrinsics.checkNotNullParameter((Object)renderer, (String)"renderer");
        Intrinsics.checkNotNullParameter((Object)innerData, (String)"innerData");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Vector3f modelOffset = new Vector3f(0.0f, -0.28125f, 0.0f);
        PartialModel partialModel = ClockworkPartials.INSTANCE.getCRYSTAL_INNER();
        RenderType renderType = RenderType.m_173239_();
        Intrinsics.checkNotNullExpressionValue((Object)renderType, (String)"endPortal(...)");
        this.renderAndTransform(matrices, partialModel, renderType, renderer, modelOffset, innerData.getOffset(), innerData.getRotation(), scale, light);
        PartialModel partialModel2 = ClockworkPartials.INSTANCE.getCRYSTAL();
        RenderType.CompositeRenderType compositeRenderType = ClockworkRenderTypes.Companion.getCRYSTAL().apply(CRYSTAL_MATRIX);
        Intrinsics.checkNotNullExpressionValue((Object)compositeRenderType, (String)"apply(...)");
        this.renderAndTransform(matrices, partialModel2, (RenderType)compositeRenderType, renderer, modelOffset, data.getOffset(), data.getRotation(), scale, light);
        PartialModel partialModel3 = ClockworkPartials.INSTANCE.getCRYSTAL_OUTER();
        RenderType renderType2 = RenderType.m_110473_((ResourceLocation)PURPLE_HUE);
        Intrinsics.checkNotNullExpressionValue((Object)renderType2, (String)"entityTranslucent(...)");
        this.renderAndTransform(matrices, partialModel3, renderType2, renderer, modelOffset, data.getOffset(), data.getRotation(), scale, light);
    }

    public final void renderCube(@NotNull PoseStack matrices, @NotNull PartialItemModelRenderer renderer, @NotNull TransformData data, float scale, int light) {
        Intrinsics.checkNotNullParameter((Object)matrices, (String)"matrices");
        Intrinsics.checkNotNullParameter((Object)renderer, (String)"renderer");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Vector3f modelOffset = new Vector3f(0.0f, -0.28125f, 0.0f);
        PartialModel partialModel = ClockworkPartials.INSTANCE.getCRYSTAL();
        RenderType.CompositeRenderType compositeRenderType = ClockworkRenderTypes.Companion.getCRYSTAL().apply(CRYSTAL_MATRIX);
        Intrinsics.checkNotNullExpressionValue((Object)compositeRenderType, (String)"apply(...)");
        this.renderAndTransform(matrices, partialModel, (RenderType)compositeRenderType, renderer, modelOffset, data.getOffset(), data.getRotation(), scale, light);
        PartialModel partialModel2 = ClockworkPartials.INSTANCE.getCRYSTAL_OUTER();
        RenderType renderType = RenderType.m_110473_((ResourceLocation)PURPLE_HUE);
        Intrinsics.checkNotNullExpressionValue((Object)renderType, (String)"entityTranslucent(...)");
        this.renderAndTransform(matrices, partialModel2, renderType, renderer, modelOffset, data.getOffset(), data.getRotation(), scale, light);
    }

    public final void renderAndTransform(@NotNull PoseStack matrices, @NotNull PartialModel model, @NotNull RenderType renderType, @NotNull PartialItemModelRenderer renderer, @NotNull Vector3f modelCorrection, @NotNull Vector3f offset, @NotNull Vector3f rotationVec, float scale, int light) {
        Intrinsics.checkNotNullParameter((Object)matrices, (String)"matrices");
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)renderType, (String)"renderType");
        Intrinsics.checkNotNullParameter((Object)renderer, (String)"renderer");
        Intrinsics.checkNotNullParameter((Object)modelCorrection, (String)"modelCorrection");
        Intrinsics.checkNotNullParameter((Object)offset, (String)"offset");
        Intrinsics.checkNotNullParameter((Object)rotationVec, (String)"rotationVec");
        matrices.m_85836_();
        matrices.m_85837_((double)offset.x(), (double)offset.y(), (double)offset.z());
        matrices.m_85837_(0.25, 0.25, 0.25);
        matrices.m_85836_();
        matrices.m_85841_(scale, scale, scale);
        matrices.m_85837_(-(1.0 / ((double)scale * (double)4)), -(1.0 / ((double)scale * (double)4)), -(1.0 / ((double)scale * (double)4)));
        matrices.m_85837_(-((double)modelCorrection.x()), -((double)modelCorrection.y()), -((double)modelCorrection.z()));
        matrices.m_252781_(Axis.f_252436_.m_252977_(rotationVec.y()));
        matrices.m_252781_(Axis.f_252529_.m_252977_(rotationVec.x()));
        matrices.m_252781_(Axis.f_252403_.m_252977_(rotationVec.z()));
        matrices.m_85837_((double)modelCorrection.x(), (double)modelCorrection.y(), (double)modelCorrection.z());
        renderer.render(model.get(), renderType, light);
        matrices.m_85849_();
        matrices.m_85849_();
    }

    public final void renderCubeMatrix(@NotNull PoseStack matrices, @NotNull MultiBufferSource buffer, @NotNull BlockState blockState, @NotNull TransformData innerData, @NotNull TransformData data, @NotNull TransformData outerData, float scale, int light) {
        Intrinsics.checkNotNullParameter((Object)matrices, (String)"matrices");
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        Intrinsics.checkNotNullParameter((Object)innerData, (String)"innerData");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)outerData, (String)"outerData");
        VertexConsumer crystal_inner_buffer = buffer.m_6299_(RenderType.m_173239_());
        SuperByteBuffer crystal_inner = CachedBufferer.partial((PartialModel)ClockworkPartials.INSTANCE.getCRYSTAL_INNER(), (BlockState)blockState);
        Intrinsics.checkNotNull((Object)crystal_inner);
        this.renderAndTransform(crystal_inner, scale, innerData.getOffset(), innerData.getRotation()).light(light).color(255, 255, 255, 255).overlay().disableDiffuse().renderInto(matrices, crystal_inner_buffer);
        VertexConsumer crystal_buffer = buffer.m_6299_((RenderType)ClockworkRenderTypes.Companion.getCRYSTAL().apply(CRYSTAL_MATRIX));
        SuperByteBuffer crystal = CachedBufferer.partial((PartialModel)ClockworkPartials.INSTANCE.getCRYSTAL(), (BlockState)blockState);
        Intrinsics.checkNotNull((Object)crystal);
        this.renderAndTransform(crystal, scale, data.getOffset(), data.getRotation()).light(light).color(255, 255, 255, 255).overlay().disableDiffuse().renderInto(matrices, crystal_buffer);
        VertexConsumer crystal_outer_buffer = buffer.m_6299_(RenderType.m_110473_((ResourceLocation)PURPLE_HUE));
        SuperByteBuffer crystal_outer = CachedBufferer.partial((PartialModel)ClockworkPartials.INSTANCE.getCRYSTAL_OUTER(), (BlockState)blockState);
        Intrinsics.checkNotNull((Object)crystal_outer);
        this.renderAndTransform(crystal_outer, scale, outerData.getOffset(), outerData.getRotation()).light(light).color(255, 255, 255, 255).overlay().renderInto(matrices, crystal_outer_buffer);
    }

    private final SuperByteBuffer renderAndTransform(SuperByteBuffer buffer, float scale, Vector3f coreOffset, Vector3f coreRotation) {
        buffer.scale(scale);
        buffer.translate(-(1.0 / ((double)scale * (double)4)), -(1.0 / ((double)scale * (double)4)), -(1.0 / ((double)scale * (double)4)));
        ((SuperByteBuffer)buffer.translateY((double)(coreOffset.y * (float)2))).rotateCentered(Direction.UP, (float)((double)(coreRotation.y / (float)180) * Math.PI));
        ((SuperByteBuffer)buffer.translateY((double)(coreOffset.z * (float)2))).rotateCentered(Direction.NORTH, (float)((double)(coreRotation.z / (float)180) * Math.PI));
        ((SuperByteBuffer)buffer.translateY((double)(coreOffset.x * (float)2))).rotateCentered(Direction.EAST, (float)((double)(coreRotation.x / (float)180) * Math.PI));
        buffer.translateY(-0.28125);
        return buffer;
    }
}

