/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import de.maxhenkel.car.Main;
import de.maxhenkel.car.blocks.tileentity.TileEntityCarWorkshop;
import de.maxhenkel.car.corelib.inventory.ScreenBase;
import de.maxhenkel.car.corelib.math.MathUtils;
import de.maxhenkel.car.entity.car.base.EntityCarBase;
import de.maxhenkel.car.entity.car.base.EntityCarDamageBase;
import de.maxhenkel.car.gui.ContainerCarWorkshopRepair;
import de.maxhenkel.car.net.MessageOpenCarWorkshopGui;
import de.maxhenkel.car.net.MessageRepairCar;
import de.maxhenkel.tools.EntityTools;
import java.util.ArrayList;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;

public class GuiCarWorkshopRepair
extends ScreenBase<ContainerCarWorkshopRepair> {
    private static final ResourceLocation GUI_TEXTURE = new ResourceLocation("car", "textures/gui/gui_car_workshop_repair.png");
    private Player player;
    private TileEntityCarWorkshop tile;
    private Button buttonBack;
    private Button buttonRepair;
    private EntityTools.CarRenderer carRenderer;

    public GuiCarWorkshopRepair(ContainerCarWorkshopRepair container, Inventory playerInventory, Component title) {
        super(GUI_TEXTURE, container, playerInventory, title);
        this.player = container.getPlayer();
        this.tile = container.getTile();
        this.carRenderer = new EntityTools.CarRenderer();
        this.f_97726_ = 176;
        this.f_97727_ = 222;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.buttonRepair = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"button.car.repair_car"), button -> {
            if (this.tile.m_58904_().f_46443_) {
                Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageRepairCar(this.tile.m_58899_(), this.player));
            }
        }).m_252987_(this.f_97735_ + this.f_97726_ - 7 - 60, this.f_97736_ + 105, 60, 20).m_253136_());
        this.buttonRepair.f_93623_ = false;
        this.buttonBack = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"button.car.back"), button -> {
            if (this.tile.m_58904_().f_46443_) {
                Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageOpenCarWorkshopGui(this.tile.m_58899_(), this.player, false));
            }
        }).m_252987_(this.f_97735_ + 7, this.f_97736_ + 105, 60, 20).m_253136_());
        this.buttonBack.f_93623_ = true;
    }

    @Override
    protected void m_280003_(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.m_280003_(guiGraphics, mouseX, mouseY);
        guiGraphics.m_280649_(this.f_96547_, this.tile.m_5446_().m_7532_(), 8, 6, 0x404040, false);
        guiGraphics.m_280649_(this.f_96547_, this.player.m_150109_().m_5446_().m_7532_(), 8, this.f_97727_ - 96 + 2, 0x404040, false);
        EntityCarBase carTop = this.tile.getCarOnTop();
        if (!(carTop instanceof EntityCarDamageBase)) {
            this.buttonRepair.f_93623_ = false;
            return;
        }
        EntityCarDamageBase car = (EntityCarDamageBase)carTop;
        if (mouseX >= this.f_97735_ + 52 && mouseX <= this.f_97735_ + 123 && mouseY >= this.f_97736_ + 81 && mouseY <= this.f_97736_ + 90) {
            ArrayList<FormattedCharSequence> list = new ArrayList<FormattedCharSequence>();
            list.add(Component.m_237110_((String)"tooltip.damage", (Object[])new Object[]{Float.valueOf(MathUtils.round(car.getDamage(), 2))}).m_7532_());
            guiGraphics.m_280245_(this.f_96547_, list, mouseX - this.f_97735_, mouseY - this.f_97736_);
        }
        this.buttonRepair.f_93623_ = this.tile.areRepairItemsInside() && car.getDamage() > 0.0f;
        this.drawCar(guiGraphics, carTop);
    }

    public void m_181908_() {
        super.m_181908_();
        this.carRenderer.tick();
    }

    private void drawCar(GuiGraphics guiGraphics, EntityCarBase car) {
        this.carRenderer.render(guiGraphics, car, this.f_97726_ / 2, 55, 23);
    }

    public double getDamagePercent(EntityCarDamageBase car) {
        float dmg = car.getDamage();
        dmg = Math.min(dmg, 100.0f);
        return MathUtils.round(dmg, 2);
    }

    @Override
    protected void m_7286_(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        super.m_7286_(guiGraphics, partialTicks, mouseX, mouseY);
        this.drawDamage(guiGraphics);
    }

    public void drawDamage(GuiGraphics guiGraphics) {
        EntityCarBase car = this.tile.getCarOnTop();
        if (!(car instanceof EntityCarDamageBase)) {
            return;
        }
        EntityCarDamageBase c = (EntityCarDamageBase)car;
        double percent = 100.0 - this.getDamagePercent(c);
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int scaled = (int)(72.0 * percent / 100.0);
        int i = this.f_97735_;
        int j = this.f_97736_;
        guiGraphics.m_280218_(GUI_TEXTURE, i + 52, j + 81, 176, 0, scaled, 10);
    }

    public boolean m_7043_() {
        return false;
    }
}

