/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.data;

import com.endertech.common.KeyValuePair;
import com.endertech.minecraft.forge.data.ResourceType;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

class Headers {
    private final List<KeyValuePair> headers = new ArrayList<KeyValuePair>();

    static Headers of() {
        return new Headers();
    }

    static Headers firefoxGet(String userAgent, URI link, ResourceType type, boolean encoding, Optional<URI> referer, Optional<String> cookies) {
        Headers headers = Headers.of().host(link).userAgent(userAgent);
        Headers headers2 = headers.accept(switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case ResourceType.HTML -> "text/html,application/xhtml+xml,application/xml;q=0.9,image/avif,image/webp,*/*;q=0.8";
            case ResourceType.IMAGE -> "image/avif,image/webp,*/*";
            case ResourceType.CSS -> "text/css,*/*;q=0.1";
            case ResourceType.SCRIPT -> "*/*";
        }).acceptLanguage("en-US,en;q=0.5").acceptEncoding(encoding, "gzip, deflate, br").altUsed(link, referer).connectionKeepAlive().referer(link, referer).cookies(cookies).upgradeInsecureRequestsIf(type == ResourceType.HTML);
        Headers headers3 = headers2.secFetchDest(switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case ResourceType.HTML -> "document";
            case ResourceType.IMAGE -> "image";
            case ResourceType.CSS -> "style";
            case ResourceType.SCRIPT -> "script";
        });
        return headers3.secFetchMode(switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case ResourceType.HTML -> "navigate";
            case ResourceType.IMAGE, ResourceType.CSS, ResourceType.SCRIPT -> "no-cors";
        }).secFetchSite(link, referer).secFetchUserIf(type == ResourceType.HTML).add("TE", "trailers");
    }

    static Headers chromeGet(String userAgent, URI link, ResourceType type, boolean encoding, Optional<URI> referer, Optional<String> cookies, Optional<String> sec_ch_ua) {
        Headers headers = Headers.of().host(link).connectionKeepAlive().addIf(sec_ch_ua.isPresent(), "sec-ch-ua", sec_ch_ua.get()).add("sec-ch-ua-mobile", "?0").addIf(userAgent.contains("(Windows"), "sec-ch-ua-platform", "\"Windows\"").upgradeInsecureRequestsIf(type == ResourceType.HTML).userAgent(userAgent);
        Headers headers2 = headers.accept(switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case ResourceType.HTML -> "text/html,application/xhtml+xml,application/xml;q=0.9,image/avif,image/webp,image/apng,*/*;q=0.8,application/signed-exchange;v=b3;q=0.9";
            case ResourceType.IMAGE -> "image/avif,image/webp,image/apng,image/svg+xml,image/*,*/*;q=0.8";
            case ResourceType.CSS -> "text/css,*/*;q=0.1";
            case ResourceType.SCRIPT -> "*/*";
        }).secFetchSite(link, referer);
        Headers headers3 = headers2.secFetchMode(switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case ResourceType.HTML -> "navigate";
            case ResourceType.IMAGE, ResourceType.CSS, ResourceType.SCRIPT -> "no-cors";
        }).secFetchUserIf(type == ResourceType.HTML);
        return headers3.secFetchDest(switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case ResourceType.HTML -> "document";
            case ResourceType.IMAGE -> "image";
            case ResourceType.CSS -> "style";
            case ResourceType.SCRIPT -> "script";
        }).referer(link, referer).acceptEncoding(encoding, "gzip, deflate, br").acceptLanguage("en-US,en;q=0.5").cookies(cookies);
    }

    Headers() {
    }

    Headers add(String name, String value) {
        this.headers.add(new KeyValuePair(name, value));
        return this;
    }

    Headers addIf(boolean condition, String name, String value) {
        return condition ? this.add(name, value) : this;
    }

    Headers host(URI link) {
        return this.add("Host", link.getHost());
    }

    Headers userAgent(String agent) {
        return this.add("User-Agent", agent);
    }

    Headers accept(String accept) {
        return this.add("Accept", accept);
    }

    Headers acceptLanguage(String language) {
        return this.add("Accept-Language", language);
    }

    Headers acceptEncoding(boolean accept, String encoding) {
        return accept ? this.add("Accept-Encoding", encoding) : this;
    }

    Headers DNT() {
        return this.add("DNT", "1");
    }

    Headers altUsed(URI link, Optional<URI> referer) {
        referer.filter(uri -> link.getHost().equalsIgnoreCase(uri.getHost())).ifPresent(uri -> this.add("Alt-Used", uri.getHost()));
        return this;
    }

    Headers connectionKeepAlive() {
        return this.add("Connection", "keep-alive");
    }

    Headers referer(URI link, Optional<URI> referer) {
        referer.ifPresent(ref -> {
            if (!link.getHost().equalsIgnoreCase(ref.getHost()) || Objects.isNull(ref.getPath()) || ref.getPath().isEmpty()) {
                ref = ref.resolve("/");
            }
            this.add("Referer", ref.toString());
        });
        return this;
    }

    Headers cookies(Optional<String> cookies) {
        cookies.ifPresent(value -> this.add("Cookie", (String)value));
        return this;
    }

    Headers upgradeInsecureRequestsIf(boolean condition) {
        return this.addIf(condition, "Upgrade-Insecure-Requests", "1");
    }

    Headers secFetchDest(String destination) {
        return this.add("Sec-Fetch-Dest", destination);
    }

    Headers secFetchMode(String mode) {
        return this.add("Sec-Fetch-Mode", mode);
    }

    Headers secFetchSite(String site) {
        return this.add("Sec-Fetch-Site", site);
    }

    Headers secFetchSite(URI link, Optional<URI> referer) {
        String site = referer.map(uri -> link.getHost().equalsIgnoreCase(uri.getHost()) ? "same-origin" : "cross-site").orElse("none");
        return this.secFetchSite(site);
    }

    Headers secFetchUserIf(boolean condition) {
        return this.addIf(condition, "Sec-Fetch-User", "?1");
    }

    Headers pragma(String value) {
        return this.add("Pragma", value);
    }

    Headers cacheControlIf(boolean condition, String value) {
        return this.addIf(condition, "Cache-Control", value);
    }

    List<KeyValuePair> asList() {
        return Collections.unmodifiableList(this.headers);
    }
}

