/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.network;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;
import org.apache.logging.log4j.Logger;
import team.creative.creativecore.CreativeCore;
import team.creative.creativecore.common.level.ISubLevel;
import team.creative.creativecore.common.network.CreativeNetworkPacket;
import team.creative.creativecore.common.network.CreativePacket;

public class CreativeNetwork {
    private final HashMap<Class<? extends CreativePacket>, CreativeNetworkPacket> packetTypes = new HashMap();
    private final Logger logger;
    private final String version;
    private int id = 0;
    public final SimpleChannel instance;

    @OnlyIn(value=Dist.CLIENT)
    private static Player getClientPlayer() {
        return Minecraft.m_91087_().f_91074_;
    }

    public static boolean isSideOnlyPresent(Field field) {
        return field.isAnnotationPresent(OnlyIn.class);
    }

    public CreativeNetwork(int version, Logger logger, ResourceLocation location) {
        this.logger = logger;
        this.version = "" + version;
        this.instance = NetworkRegistry.newSimpleChannel((ResourceLocation)location, () -> this.version, x -> true, this.version::equals);
        this.logger.debug("Created network " + location);
    }

    public <T extends CreativePacket> void registerType(Class<T> classType, Supplier<T> supplier) {
        CreativeNetworkPacket<T> handler = new CreativeNetworkPacket<T>(classType, supplier);
        this.instance.registerMessage(this.id, classType, handler::write, handler::read, (message, ctx) -> {
            ((NetworkEvent.Context)ctx.get()).enqueueWork(() -> CreativeNetwork.lambda$registerType$2(message, (Supplier)ctx));
            ((NetworkEvent.Context)ctx.get()).setPacketHandled(true);
        });
        this.packetTypes.put(classType, handler);
        ++this.id;
    }

    public CreativeNetworkPacket getPacketType(Class<? extends CreativePacket> clazz) {
        return this.packetTypes.get(clazz);
    }

    public void sendToServer(CreativePacket message) {
        this.instance.sendToServer((Object)message);
    }

    public void sendToClient(CreativePacket message, ServerPlayer player) {
        this.instance.send(PacketDistributor.PLAYER.with(() -> player), (Object)message);
    }

    public void sendToClient(CreativePacket message, Level level, BlockPos pos) {
        if (level instanceof ISubLevel) {
            this.sendToClientTracking(message, ((ISubLevel)level).getHolder());
        } else {
            this.sendToClient(message, level.m_46745_(pos));
        }
    }

    public void sendToClient(CreativePacket message, LevelChunk chunk) {
        this.instance.send(PacketDistributor.TRACKING_CHUNK.with(() -> chunk), (Object)message);
    }

    public void sendToClientTracking(CreativePacket message, Entity entity) {
        Level level = entity.m_9236_();
        if (level instanceof ISubLevel) {
            ISubLevel sub = (ISubLevel)level;
            this.sendToClientTracking(message, sub.getHolder());
        } else {
            this.instance.send(PacketDistributor.TRACKING_ENTITY.with(() -> entity), (Object)message);
        }
    }

    public void sendToClientTrackingAndSelf(CreativePacket message, Entity entity) {
        Level level = entity.m_9236_();
        if (level instanceof ISubLevel) {
            ISubLevel sub = (ISubLevel)level;
            this.sendToClientTrackingAndSelf(message, sub.getHolder());
        } else {
            this.instance.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> entity), (Object)message);
        }
    }

    public void sendToClientAll(MinecraftServer server, CreativePacket message) {
        this.instance.send(PacketDistributor.ALL.noArg(), (Object)message);
    }

    private static /* synthetic */ void lambda$registerType$2(CreativePacket message, Supplier ctx) {
        try {
            message.execute((Player)(((NetworkEvent.Context)ctx.get()).getSender() == null ? CreativeNetwork.getClientPlayer() : ((NetworkEvent.Context)ctx.get()).getSender()));
        }
        catch (Throwable e) {
            CreativeCore.LOGGER.error("Executing a packet ran into an exception", e);
            CreativeCore.LOGGER.catching(e);
            throw e;
        }
    }
}

