/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.mixin.camera;

import com.google.common.collect.ImmutableList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.geforcemods.securitycraft.blockentities.SecurityCameraBlockEntity;
import net.geforcemods.securitycraft.entity.camera.SecurityCamera;
import net.geforcemods.securitycraft.misc.BlockEntityTracker;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.network.protocol.game.ClientboundLevelChunkWithLightPacket;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.PlayerMap;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.entity.EntityAccess;
import org.apache.commons.lang3.mutable.MutableObject;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={ChunkMap.class}, priority=1100)
public abstract class ChunkMapMixin {
    @Unique
    private static final Map<ServerPlayer, SectionPos> OLD_SECTION_POSITIONS = new HashMap<ServerPlayer, SectionPos>();
    @Shadow
    @Final
    private PlayerMap f_140149_;
    @Shadow
    int f_140126_;

    @Shadow
    protected abstract void m_183754_(ServerPlayer var1, ChunkPos var2, MutableObject<ClientboundLevelChunkWithLightPacket> var3, boolean var4, boolean var5);

    @Inject(method={"setViewDistance"}, at={@At(value="HEAD")})
    private void securitycraft$setCameraSectionPos(int viewDistance, CallbackInfo ci) {
        for (ServerPlayer player : this.f_140149_.m_183926_(0L)) {
            if (!PlayerUtils.isPlayerMountedOnCamera((LivingEntity)player)) continue;
            OLD_SECTION_POSITIONS.put(player, player.m_8965_());
            player.m_9119_(SectionPos.m_235861_((EntityAccess)player.m_8954_()));
        }
    }

    @Inject(method={"setViewDistance"}, at={@At(value="TAIL")})
    private void securitycraft$restorePreviousSectionPos(int viewDistance, CallbackInfo ci) {
        for (Map.Entry<ServerPlayer, SectionPos> entry : OLD_SECTION_POSITIONS.entrySet()) {
            entry.getKey().m_9119_(entry.getValue());
        }
        OLD_SECTION_POSITIONS.clear();
    }

    @Redirect(method={"getPlayers"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerPlayer;getLastSectionPos()Lnet/minecraft/core/SectionPos;"))
    private SectionPos securitycraft$getCameraSectionPos(ServerPlayer player) {
        if (PlayerUtils.isPlayerMountedOnCamera((LivingEntity)player)) {
            return SectionPos.m_235861_((EntityAccess)player.m_8954_());
        }
        return player.m_8965_();
    }

    @Inject(method={"move"}, at={@At(value="TAIL")})
    private void securitycraft$trackCameraLoadedChunks(ServerPlayer player, CallbackInfo ci) {
        Object camera;
        Level level = player.m_9236_();
        ChunkPos playerPos = player.m_146902_();
        Entity entity = player.m_8954_();
        if (entity instanceof SecurityCamera && !((SecurityCamera)((Object)(camera = (SecurityCamera)entity))).hasSentChunks()) {
            SectionPos pos = SectionPos.m_235861_((EntityAccess)camera);
            for (int i = pos.m_123170_() - this.f_140126_; i <= pos.m_123170_() + this.f_140126_; ++i) {
                for (int j = pos.m_123222_() - this.f_140126_; j <= pos.m_123222_() + this.f_140126_; ++j) {
                    if (Utils.isInViewDistance(playerPos.f_45578_, playerPos.f_45579_, this.f_140126_, i, j)) continue;
                    this.m_183754_(player, new ChunkPos(i, j), (MutableObject<ClientboundLevelChunkWithLightPacket>)new MutableObject(), false, true);
                }
            }
            ((SecurityCamera)((Object)camera)).setHasSentChunks(true);
        }
        for (SecurityCameraBlockEntity viewedCamera : BlockEntityTracker.FRAME_VIEWED_SECURITY_CAMERAS.getBlockEntitiesWithCondition(level, be -> be.shouldSendChunksToPlayer(player))) {
            SectionPos pos = SectionPos.m_123199_((BlockPos)viewedCamera.myPos());
            int cameraViewDistance = viewedCamera.getCameraFeedChunks(player).viewDistance();
            for (int i = pos.m_123170_() - cameraViewDistance; i <= pos.m_123170_() + cameraViewDistance; ++i) {
                for (int j = pos.m_123222_() - cameraViewDistance; j <= pos.m_123222_() + cameraViewDistance; ++j) {
                    if (Utils.isInViewDistance(playerPos.f_45578_, playerPos.f_45579_, this.f_140126_, i, j)) continue;
                    this.m_183754_(player, new ChunkPos(i, j), (MutableObject<ClientboundLevelChunkWithLightPacket>)new MutableObject(), false, true);
                }
            }
        }
        HashSet<SecurityCameraBlockEntity.ChunkTrackingView> unviewedChunkViews = new HashSet<SecurityCameraBlockEntity.ChunkTrackingView>();
        if (SecurityCameraBlockEntity.hasRecentlyUnviewedCameras(player)) {
            for (SecurityCameraBlockEntity viewedCamera : SecurityCameraBlockEntity.fetchRecentlyUnviewedCameras(player)) {
                SecurityCameraBlockEntity.ChunkTrackingView unviewedChunks = viewedCamera.getCameraFeedChunks(player);
                if (unviewedChunks == null) continue;
                unviewedChunkViews.add(unviewedChunks);
                viewedCamera.clearCameraFeedChunks(player);
            }
        }
        if (SecurityCamera.hasRecentlyDismounted(player)) {
            unviewedChunkViews.add(new SecurityCameraBlockEntity.ChunkTrackingView(new ChunkPos(SecurityCamera.fetchRecentDismountLocation(player)), this.f_140126_));
        }
        for (SecurityCameraBlockEntity.ChunkTrackingView unviewedChunkView : unviewedChunkViews) {
            ChunkPos centerPos = unviewedChunkView.center();
            int unViewDistance = unviewedChunkView.viewDistance();
            for (int i = centerPos.f_45578_ - unViewDistance; i <= centerPos.f_45578_ + unViewDistance; ++i) {
                for (int j = centerPos.f_45579_ - unViewDistance; j <= centerPos.f_45579_ + unViewDistance; ++j) {
                    if (Utils.isInViewDistance(playerPos.f_45578_, playerPos.f_45579_, this.f_140126_, i, j) || !BlockEntityTracker.FRAME_VIEWED_SECURITY_CAMERAS.getBlockEntitiesWithCondition(level, be -> be.shouldKeepChunkTracked(player, centerPos.f_45578_, centerPos.f_45579_)).isEmpty()) continue;
                    this.m_183754_(player, new ChunkPos(i, j), (MutableObject<ClientboundLevelChunkWithLightPacket>)new MutableObject(), true, false);
                }
            }
        }
    }

    @Inject(method={"getPlayers"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerPlayer;getLastSectionPos()Lnet/minecraft/core/SectionPos;")}, locals=LocalCapture.CAPTURE_FAILSOFT)
    private void securitycraft$sendChunksToCameras(ChunkPos pos, boolean boundaryOnly, CallbackInfoReturnable<List<ServerPlayer>> cir, Set<ServerPlayer> allPlayers, ImmutableList.Builder<ServerPlayer> playerList, Iterator<Player> playerIterator, ServerPlayer player) {
        SectionPos playerPos = player.m_8965_();
        if (!ChunkMap.m_200878_((int)pos.f_45578_, (int)pos.f_45579_, (int)playerPos.m_123170_(), (int)playerPos.m_123222_(), (int)this.f_140126_)) {
            Entity entity = player.m_8954_();
            if (entity instanceof SecurityCamera) {
                SecurityCamera camera2 = (SecurityCamera)entity;
                SectionPos cameraPos = SectionPos.m_123199_((BlockPos)camera2.m_20183_());
                if (Utils.isInViewDistance(cameraPos.m_123170_(), cameraPos.m_123222_(), camera2.getChunkLoadingDistance(), pos.f_45578_, pos.f_45579_)) {
                    playerList.add((Object)player);
                }
            } else if (!BlockEntityTracker.FRAME_VIEWED_SECURITY_CAMERAS.getBlockEntitiesWithCondition(player.m_9236_(), camera -> camera.shouldKeepChunkTracked(player, pos.f_45578_, pos.f_45579_)).isEmpty()) {
                playerList.add((Object)player);
            }
        }
    }

    @Inject(method={"updateChunkTracking"}, at={@At(value="HEAD")}, cancellable=true)
    private void securitycraft$onDropChunk(ServerPlayer player, ChunkPos pos, MutableObject<ClientboundLevelChunkWithLightPacket> packetCache, boolean wasLoaded, boolean load, CallbackInfo ci) {
        if (wasLoaded && !load && !BlockEntityTracker.FRAME_VIEWED_SECURITY_CAMERAS.getBlockEntitiesWithCondition(player.m_9236_(), be -> be.shouldKeepChunkTracked(player, pos.f_45578_, pos.f_45579_)).isEmpty()) {
            ci.cancel();
        }
    }
}

