/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network.server;

import java.util.function.Supplier;
import net.geforcemods.securitycraft.api.ICustomizable;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.Option;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class UpdateSliderValue {
    private BlockPos pos;
    private String optionName;
    private double value;
    private int entityId;

    public UpdateSliderValue() {
    }

    public UpdateSliderValue(BlockPos pos, Option<?> option, double v) {
        this.pos = pos;
        this.optionName = option.getName();
        this.value = v;
    }

    public UpdateSliderValue(int entityId, Option<?> option, double v) {
        this.entityId = entityId;
        this.optionName = option.getName();
        this.value = v;
    }

    public UpdateSliderValue(FriendlyByteBuf buf) {
        if (buf.readBoolean()) {
            this.pos = buf.m_130135_();
        } else {
            this.entityId = buf.m_130242_();
        }
        this.optionName = buf.m_130277_();
        this.value = buf.readDouble();
    }

    public void encode(FriendlyByteBuf buf) {
        boolean hasPos = this.pos != null;
        buf.writeBoolean(hasPos);
        if (hasPos) {
            buf.m_130064_(this.pos);
        } else {
            buf.m_130130_(this.entityId);
        }
        buf.m_130070_(this.optionName);
        buf.writeDouble(this.value);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        IOwnable ownable;
        ServerPlayer player = ctx.get().getSender();
        Level level = player.m_9236_();
        ICustomizable customizable = this.getCustomizable(level);
        if (!(player.m_5833_() || customizable == null || customizable instanceof IOwnable && !(ownable = (IOwnable)((Object)customizable)).isOwnedBy((Entity)player))) {
            Option<?> option = null;
            for (Option<?> o : customizable.customOptions()) {
                if (!o.getName().equals(this.optionName)) continue;
                option = o;
                break;
            }
            if (option == null) {
                return;
            }
            if (option instanceof Option.EntityDataWrappedOption) {
                Option.EntityDataWrappedOption o = (Option.EntityDataWrappedOption)option;
                Option wrapped = o.getWrapped();
                if (wrapped instanceof Option.DoubleOption) {
                    o.setValue(this.value);
                } else if (wrapped instanceof Option.IntOption) {
                    o.setValue((int)this.value);
                }
            } else if (option instanceof Option.DoubleOption) {
                Option.DoubleOption o = (Option.DoubleOption)option;
                o.setValue(this.value);
            } else if (option instanceof Option.IntOption) {
                Option.IntOption o = (Option.IntOption)option;
                o.setValue((int)this.value);
            }
            customizable.onOptionChanged(option);
            if (customizable instanceof BlockEntity) {
                BlockEntity be = (BlockEntity)customizable;
                level.m_7260_(this.pos, be.m_58900_(), be.m_58900_(), 3);
            }
        }
    }

    private ICustomizable getCustomizable(Level level) {
        if (this.pos != null) {
            BlockEntity blockEntity = level.m_7702_(this.pos);
            if (blockEntity instanceof ICustomizable) {
                ICustomizable be = (ICustomizable)blockEntity;
                return be;
            }
        } else {
            Entity entity = level.m_6815_(this.entityId);
            if (entity instanceof ICustomizable) {
                ICustomizable entity2 = (ICustomizable)entity;
                return entity2;
            }
        }
        return null;
    }
}

