/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.plane.gui;

import de.maxhenkel.plane.corelib.inventory.ScreenBase;
import de.maxhenkel.plane.corelib.math.MathUtils;
import de.maxhenkel.plane.entity.EntityPlaneSoundBase;
import de.maxhenkel.plane.gui.ContainerPlane;
import java.util.ArrayList;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Inventory;

public class PlaneScreen
extends ScreenBase<ContainerPlane> {
    private static final ResourceLocation CAR_GUI_TEXTURE = new ResourceLocation("plane", "textures/gui/gui_plane.png");
    private static final Component TEXT_FUEL = Component.m_237115_((String)"gui.plane.fuel");
    private static final Component TEXT_DAMAGE = Component.m_237115_((String)"gui.plane.damage");
    private static final Component TEXT_ENGINE = Component.m_237115_((String)"gui.plane.throttle");
    private Inventory playerInv;
    private EntityPlaneSoundBase plane;

    public PlaneScreen(ContainerPlane containerCar, Inventory playerInv, Component title) {
        super(CAR_GUI_TEXTURE, containerCar, playerInv, title);
        this.playerInv = playerInv;
        this.plane = containerCar.getPlane();
        this.f_97726_ = 176;
        this.f_97727_ = 222;
    }

    @Override
    protected void m_280003_(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        ArrayList<FormattedCharSequence> list;
        super.m_280003_(guiGraphics, mouseX, mouseY);
        guiGraphics.m_280649_(this.f_96547_, this.plane.m_7755_().m_7532_(), 7, 61, 0x404040, false);
        guiGraphics.m_280649_(this.f_96547_, this.playerInv.m_5446_().m_7532_(), 8, this.f_97727_ - 96 + 2, 0x404040, false);
        guiGraphics.m_280649_(this.f_96547_, TEXT_FUEL.m_7532_(), 7, 9, 0x404040, false);
        guiGraphics.m_280649_(this.f_96547_, TEXT_DAMAGE.m_7532_(), 95, 9, 0x404040, false);
        guiGraphics.m_280649_(this.f_96547_, TEXT_ENGINE.m_7532_(), 7, 35, 0x404040, false);
        if (mouseX >= this.f_97735_ + 8 && mouseX < this.f_97735_ + 80 && mouseY >= this.f_97736_ + 20 && mouseY < this.f_97736_ + 30) {
            list = new ArrayList<FormattedCharSequence>();
            list.add(Component.m_237110_((String)"tooltip.plane.fuel", (Object[])new Object[]{String.valueOf(this.plane.getFuel())}).m_7532_());
            guiGraphics.m_280245_(this.f_96547_, list, mouseX - this.f_97735_, mouseY - this.f_97736_);
        }
        if (mouseX >= this.f_97735_ + 96 && mouseX < this.f_97735_ + 168 && mouseY >= this.f_97736_ + 20 && mouseY < this.f_97736_ + 30) {
            list = new ArrayList();
            list.add(Component.m_237110_((String)"tooltip.plane.damage", (Object[])new Object[]{String.valueOf(MathUtils.round(this.plane.getPlaneDamage(), 2))}).m_7532_());
            guiGraphics.m_280245_(this.f_96547_, list, mouseX - this.f_97735_, mouseY - this.f_97736_);
        }
        if (mouseX >= this.f_97735_ + 8 && mouseX < this.f_97735_ + 80 && mouseY >= this.f_97736_ + 46 && mouseY < this.f_97736_ + 56) {
            list = new ArrayList();
            list.add(Component.m_237110_((String)"tooltip.plane.throttle", (Object[])new Object[]{String.valueOf(Math.round(this.plane.getEngineSpeed() * 100.0f))}).m_7532_());
            guiGraphics.m_280245_(this.f_96547_, list, mouseX - this.f_97735_, mouseY - this.f_97736_);
        }
    }

    @Override
    protected void m_7286_(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        super.m_7286_(guiGraphics, partialTicks, mouseX, mouseY);
        this.drawFuel(guiGraphics, (float)this.plane.getFuel() / (float)this.plane.getMaxFuel());
        this.drawDamage(guiGraphics, (100.0f - Math.min(this.plane.getPlaneDamage(), 100.0f)) / 100.0f);
        this.drawThrottle(guiGraphics, this.plane.getEngineSpeed());
    }

    public void drawFuel(GuiGraphics guiGraphics, float percent) {
        int scaled = (int)(72.0f * percent);
        int i = this.f_97735_;
        int j = this.f_97736_;
        guiGraphics.m_280218_(this.texture, i + 8, j + 20, 176, 0, scaled, 10);
    }

    public void drawThrottle(GuiGraphics guiGraphics, float percent) {
        int scaled = (int)(72.0f * percent);
        int i = this.f_97735_;
        int j = this.f_97736_;
        guiGraphics.m_280218_(this.texture, i + 8, j + 46, 176, 10, scaled, 10);
    }

    public void drawDamage(GuiGraphics guiGraphics, float percent) {
        int scaled = (int)(72.0f * percent);
        int i = this.f_97735_;
        int j = this.f_97736_;
        guiGraphics.m_280218_(this.texture, i + 96, j + 20, 176, 20, scaled, 10);
    }
}

